/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_10.transport;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.server.protocol.v0_10.transport.Decoder;
import org.apache.qpid.server.protocol.v0_10.transport.Encoder;
import org.apache.qpid.server.protocol.v0_10.transport.Option;
import org.apache.qpid.server.protocol.v0_10.transport.Struct;

public final class FragmentProperties
extends Struct {
    public static final int TYPE = 1026;
    private short packing_flags = 0;
    private long fragmentSize;

    @Override
    public final int getStructType() {
        return 1026;
    }

    @Override
    public final int getSizeWidth() {
        return 4;
    }

    @Override
    public final int getPackWidth() {
        return 2;
    }

    public final boolean hasPayload() {
        return false;
    }

    public final byte getEncodedTrack() {
        return -1;
    }

    public final boolean isConnectionControl() {
        return false;
    }

    public FragmentProperties() {
    }

    public FragmentProperties(long fragmentSize, Option ... _options) {
        this.setFragmentSize(fragmentSize);
        block5: for (int i = 0; i < _options.length; ++i) {
            switch (_options[i]) {
                case FIRST: {
                    this.packing_flags = (short)(this.packing_flags | 0x100);
                    continue block5;
                }
                case LAST: {
                    this.packing_flags = (short)(this.packing_flags | 0x200);
                    continue block5;
                }
                case NONE: {
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("invalid option: " + _options[i]);
                }
            }
        }
    }

    public final boolean hasFirst() {
        return (this.packing_flags & 0x100) != 0;
    }

    public final FragmentProperties clearFirst() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFEFF);
        this.setDirty(true);
        return this;
    }

    public final boolean getFirst() {
        return this.hasFirst();
    }

    public final FragmentProperties setFirst(boolean value) {
        this.packing_flags = value ? (short)(this.packing_flags | 0x100) : (short)(this.packing_flags & 0xFFFFFEFF);
        this.setDirty(true);
        return this;
    }

    public final FragmentProperties first(boolean value) {
        return this.setFirst(value);
    }

    public final boolean hasLast() {
        return (this.packing_flags & 0x200) != 0;
    }

    public final FragmentProperties clearLast() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFDFF);
        this.setDirty(true);
        return this;
    }

    public final boolean getLast() {
        return this.hasLast();
    }

    public final FragmentProperties setLast(boolean value) {
        this.packing_flags = value ? (short)(this.packing_flags | 0x200) : (short)(this.packing_flags & 0xFFFFFDFF);
        this.setDirty(true);
        return this;
    }

    public final FragmentProperties last(boolean value) {
        return this.setLast(value);
    }

    public final boolean hasFragmentSize() {
        return (this.packing_flags & 0x400) != 0;
    }

    public final FragmentProperties clearFragmentSize() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFBFF);
        this.fragmentSize = 0L;
        this.setDirty(true);
        return this;
    }

    public final long getFragmentSize() {
        return this.fragmentSize;
    }

    public final FragmentProperties setFragmentSize(long value) {
        this.fragmentSize = value;
        this.packing_flags = (short)(this.packing_flags | 0x400);
        this.setDirty(true);
        return this;
    }

    public final FragmentProperties fragmentSize(long value) {
        return this.setFragmentSize(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint16(this.packing_flags);
        if ((this.packing_flags & 0x400) != 0) {
            enc.writeUint64(this.fragmentSize);
        }
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (short)dec.readUint16();
        if ((this.packing_flags & 0x400) != 0) {
            this.fragmentSize = dec.readUint64();
        }
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 0x100) != 0) {
            result.put("first", this.getFirst());
        }
        if ((this.packing_flags & 0x200) != 0) {
            result.put("last", this.getLast());
        }
        if ((this.packing_flags & 0x400) != 0) {
            result.put("fragmentSize", this.getFragmentSize());
        }
        return result;
    }

    @Override
    public int getEncodedLength() {
        throw new UnsupportedOperationException();
    }
}

