/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.security.authorization.internal;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.basyx.components.configuration.BaSyxSecurityConfiguration;
import org.eclipse.basyx.components.security.authorization.internal.IJwtBearerTokenAuthenticationConfigurationProvider;
import org.eclipse.basyx.extensions.shared.authorization.internal.KeycloakService;
import org.eclipse.basyx.vab.protocol.http.server.JwtBearerTokenAuthenticationConfiguration;

public class KeycloakJwtBearerTokenAuthenticationConfigurationProvider
implements IJwtBearerTokenAuthenticationConfigurationProvider {
    @Override
    public JwtBearerTokenAuthenticationConfiguration get(BaSyxSecurityConfiguration securityConfig) {
        String serverUrl = securityConfig.getAuthorizationStrategyJwtBearerTokenAuthenticationConfigurationProviderKeycloakServerUrl();
        String realm = securityConfig.getAuthorizationStrategyJwtBearerTokenAuthenticationConfigurationProviderKeycloakRealm();
        KeycloakService keycloakService = new KeycloakService(serverUrl, realm);
        String audience = this.getAudience(securityConfig);
        JwtBearerTokenAuthenticationConfiguration keycloakServiceJwtBearerTokenAuthenticationConfiguration = keycloakService.createJwtBearerTokenAuthenticationConfiguration();
        String issuerUri = keycloakServiceJwtBearerTokenAuthenticationConfiguration.getIssuerUri();
        String jwkSetUri = keycloakServiceJwtBearerTokenAuthenticationConfiguration.getJwkSetUri();
        return JwtBearerTokenAuthenticationConfiguration.of((String)issuerUri, (String)jwkSetUri, (String)audience);
    }

    private String getAudience(BaSyxSecurityConfiguration securityConfig) {
        String audience = securityConfig.getAuthorizationStrategyJwtBearerTokenAuthenticationConfigurationProviderAudience();
        if (audience == null || StringUtils.isBlank((CharSequence)audience)) {
            return null;
        }
        return audience;
    }
}

