/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors;

import de.iip_ecosphere.platform.connectors.Connector;
import de.iip_ecosphere.platform.connectors.ConnectorDescriptor;
import de.iip_ecosphere.platform.connectors.ConnectorsAas;
import de.iip_ecosphere.platform.support.jsl.ServiceLoaderUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;

public class ConnectorRegistry {
    private static final List<Connector<?, ?, ?, ?>> INSTANCES = Collections.synchronizedList(new ArrayList());

    public static ServiceLoader<ConnectorDescriptor> getRegisteredConnectorDescriptorsLoader() {
        return ServiceLoaderUtils.load(ConnectorDescriptor.class);
    }

    public static Iterator<ConnectorDescriptor> getRegisteredConnectorDescriptors() {
        ServiceLoader<ConnectorDescriptor> loader = ConnectorRegistry.getRegisteredConnectorDescriptorsLoader();
        return loader.iterator();
    }

    public static void registerConnector(Connector<?, ?, ?, ?> instance) {
        INSTANCES.add(instance);
        ConnectorsAas.notifyAddConnector(instance);
    }

    public static void unregisterConnector(Connector<?, ?, ?, ?> instance) {
        INSTANCES.remove(instance);
        ConnectorsAas.notifyRemoveConnector(instance);
    }

    public static int getRegisteredConnectorInstancesCount() {
        return INSTANCES.size();
    }

    public static Iterator<Connector<?, ?, ?, ?>> getRegisteredConnectorInstances() {
        return INSTANCES.iterator();
    }
}

