/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.auth;

import java.nio.charset.StandardCharsets;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import org.apache.qpid.server.management.plugin.HttpManagementConfiguration;
import org.apache.qpid.server.management.plugin.HttpRequestPreemptiveAuthenticator;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.security.SubjectCreator;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.SubjectAuthenticationResult;
import org.apache.qpid.server.security.auth.manager.UsernamePasswordAuthenticationProvider;
import org.apache.qpid.server.util.Strings;

@PluggableService
public class BasicAuthPreemptiveAuthenticator
implements HttpRequestPreemptiveAuthenticator {
    private static final String BASIC_AUTH = "BasicAuth";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Subject attemptAuthentication(HttpServletRequest request, HttpManagementConfiguration managementConfiguration) {
        String header = request.getHeader("Authorization");
        Port<?> port = managementConfiguration.getPort(request);
        AuthenticationProvider authenticationProvider = managementConfiguration.getAuthenticationProvider(request);
        SubjectCreator subjectCreator = port.getSubjectCreator(request.isSecure(), request.getServerName());
        if (header != null && authenticationProvider instanceof UsernamePasswordAuthenticationProvider) {
            UsernamePasswordAuthenticationProvider namePasswdAuthProvider = (UsernamePasswordAuthenticationProvider)authenticationProvider;
            String[] tokens = header.split("\\s");
            if (tokens.length >= 2 && "BASIC".equalsIgnoreCase(tokens[0])) {
                boolean isBasicAuthSupported;
                boolean bl = isBasicAuthSupported = request.isSecure() ? managementConfiguration.isHttpsBasicAuthenticationEnabled() : managementConfiguration.isHttpBasicAuthenticationEnabled();
                if (isBasicAuthSupported) {
                    byte[] base64EncodedContent;
                    block5: {
                        Subject subject;
                        base64EncodedContent = Strings.decodeCharArray((char[])tokens[1].toCharArray(), (String)"basic authentication credentials");
                        try {
                            String[] decodedHeaderContent = new String(base64EncodedContent, StandardCharsets.UTF_8).split(":", 2);
                            if (decodedHeaderContent.length != 2) break block5;
                            String token1 = decodedHeaderContent[0];
                            String token2 = decodedHeaderContent[1];
                            AuthenticationResult authenticationResult = namePasswdAuthProvider.authenticate(token1, token2);
                            SubjectAuthenticationResult result = subjectCreator.createResultWithGroups(authenticationResult);
                            subject = result.getSubject();
                        }
                        catch (Throwable throwable) {
                            Strings.clearByteArray((byte[][])new byte[][]{base64EncodedContent});
                            throw throwable;
                        }
                        Strings.clearByteArray((byte[][])new byte[][]{base64EncodedContent});
                        return subject;
                    }
                    Strings.clearByteArray((byte[][])new byte[][]{base64EncodedContent});
                }
            }
        }
        return null;
    }

    public String getType() {
        return BASIC_AUTH;
    }
}

