/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.expression.comparison;

import java.math.BigDecimal;
import org.apache.qpid.server.query.engine.exception.QueryEvaluationException;
import org.apache.qpid.server.query.engine.exception.QueryParsingException;
import org.apache.qpid.server.query.engine.parsing.converter.DateTimeConverter;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.comparison.AbstractComparisonExpression;
import org.apache.qpid.server.query.engine.parsing.expression.set.EmptySetExpression;
import org.apache.qpid.server.query.engine.parsing.utils.StringUtils;
import org.apache.qpid.server.query.engine.validation.FunctionParameterTypePredicate;

public class GreaterThanOrEqualExpression<T, R>
extends AbstractComparisonExpression<T, Boolean> {
    private final FunctionParameterTypePredicate<R> _typeValidator = FunctionParameterTypePredicate.builder().allowDateTimeTypes().allowEnums().allowNumbers().allowComparables().allowStrings().disallowBooleans().build();

    public GreaterThanOrEqualExpression(ExpressionNode<T, ?> left, ExpressionNode<T, ?> right) {
        super(left, right);
        this._operator = ">=";
    }

    @Override
    public Boolean apply(T value) {
        Object left = this.evaluateChild(0, value);
        Object right = this.evaluateChild(1, value);
        if (right instanceof EmptySetExpression) {
            return Boolean.FALSE;
        }
        if (!this._typeValidator.test(left) || !this._typeValidator.test(right)) {
            throw QueryEvaluationException.of("Objects of types '%s' and '%s' can not be compared", StringUtils.getClassName(left), StringUtils.getClassName(right));
        }
        if (left instanceof Number && right instanceof Number) {
            return new BigDecimal(left.toString()).compareTo(new BigDecimal(right.toString())) >= 0;
        }
        if (DateTimeConverter.isDateTime(left) || DateTimeConverter.isDateTime(right)) {
            return DateTimeConverter.toInstantMapper().apply(left).compareTo(DateTimeConverter.toInstantMapper().apply(right)) >= 0;
        }
        if (left instanceof Comparable && right instanceof Comparable) {
            Comparable leftComparable = (Comparable)left;
            return leftComparable.compareTo(right) >= 0;
        }
        throw QueryParsingException.of("Objects of types '%s' and '%s' can not be compared", StringUtils.getClassName(left), StringUtils.getClassName(right));
    }
}

