/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.iip_aas;

import de.iip_ecosphere.platform.support.iip_aas.IdProvider;
import de.iip_ecosphere.platform.support.iip_aas.IdProviderDescriptor;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

public class MacIdProvider
implements IdProvider {
    @Override
    public String provideId() {
        ArrayList<String> macAddresses = new ArrayList<String>();
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            this.addAddress(NetworkInterface.getByInetAddress(localHost), macAddresses);
        }
        catch (IOException e) {
            LoggerFactory.getLogger(MacIdProvider.class).error("Obtaining MAC-based device ID: " + e.getMessage());
        }
        try {
            Enumeration<NetworkInterface> ne = NetworkInterface.getNetworkInterfaces();
            while (ne.hasMoreElements()) {
                this.addAddress(ne.nextElement(), macAddresses);
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(MacIdProvider.class).error("Obtaining MAC-based device ID: " + e.getMessage());
        }
        String macAddress = null;
        if (macAddresses.size() > 0) {
            Collections.sort(macAddresses);
            macAddress = (String)macAddresses.get(macAddresses.size() - 1);
        }
        return macAddress;
    }

    private void addAddress(NetworkInterface ni, List<String> addresses) {
        if (null != ni) {
            try {
                byte[] hardwareAddress = ni.getHardwareAddress();
                if (null != hardwareAddress) {
                    CharSequence[] hexadecimal = new String[hardwareAddress.length];
                    for (int i = 0; i < hardwareAddress.length; ++i) {
                        hexadecimal[i] = String.format("%02X", hardwareAddress[i]);
                    }
                    addresses.add(String.join((CharSequence)"", hexadecimal));
                }
            }
            catch (SocketException e) {
                LoggerFactory.getLogger(MacIdProvider.class).warn("Obtaining MAC-based device ID: " + e.getMessage());
            }
        }
    }

    @Override
    public boolean allowsConsoleOverride() {
        return true;
    }

    public static class MacIdProviderDescriptor
    implements IdProviderDescriptor {
        @Override
        public IdProvider createProvider() {
            return new MacIdProvider();
        }
    }
}

