/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.iip_aas;

import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.iip_aas.ActiveAasBase;
import de.iip_ecosphere.platform.support.iip_aas.NetworkManagerAas;
import de.iip_ecosphere.platform.support.iip_aas.SubmodelClient;
import de.iip_ecosphere.platform.support.iip_aas.config.ServerAddressHolder;
import de.iip_ecosphere.platform.support.net.AbstractNetworkManagerImpl;
import de.iip_ecosphere.platform.support.net.ManagedServerAddress;
import java.io.IOException;
import java.util.concurrent.ExecutionException;

public class NetworkManagerAasClient
extends AbstractNetworkManagerImpl {
    private Submodel submodel;

    public NetworkManagerAasClient() throws IOException {
        this(ActiveAasBase.getSubmodel("netMgt"));
    }

    public NetworkManagerAasClient(Submodel submodel) {
        this.submodel = submodel;
    }

    public ManagedServerAddress obtainPort(String key) {
        try {
            NetworkManagerAasClient.checkKey((String)key);
            String tmp = SubmodelClient.checkString(SubmodelClient.getOperation(this.submodel, "obtainPort").invoke(new Object[]{key}));
            return SubmodelClient.checkNotNull(NetworkManagerAas.managedServerAddressFromJson(tmp));
        }
        catch (ExecutionException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public ManagedServerAddress getPort(String key) {
        try {
            NetworkManagerAasClient.checkKey((String)key);
            Object tmp = SubmodelClient.getOperation(this.submodel, "getPort").invoke(new Object[]{key});
            return NetworkManagerAas.managedServerAddressFromJson(tmp);
        }
        catch (ExecutionException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public ManagedServerAddress reservePort(String key, ServerAddress address) {
        try {
            NetworkManagerAasClient.checkKey((String)key);
            NetworkManagerAasClient.checkAddress((ServerAddress)address);
            String tmp = SubmodelClient.checkString(SubmodelClient.getOperation(this.submodel, "reservePort").invoke(new Object[]{key, ServerAddressHolder.toJson(SubmodelClient.checkNotNull(address))}));
            return SubmodelClient.checkNotNull(NetworkManagerAas.managedServerAddressFromJson(tmp));
        }
        catch (ExecutionException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void releasePort(String key) {
        try {
            NetworkManagerAasClient.checkKey((String)key);
            SubmodelClient.getOperation(this.submodel, "releasePort").invoke(new Object[]{key});
        }
        catch (ExecutionException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public boolean isInUse(ServerAddress address) {
        NetworkManagerAasClient.checkAddress((ServerAddress)address);
        boolean result = false;
        try {
            Object tmp = SubmodelClient.getOperation(this.submodel, "isInUsePortAdr").invoke(new Object[]{ServerAddressHolder.toJson(address)});
            if (tmp instanceof Boolean) {
                result = (Boolean)tmp;
            }
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return result;
    }

    public boolean isInUse(int port) {
        boolean result = false;
        try {
            Object tmp = SubmodelClient.getOperation(this.submodel, "isInUsePortPort").invoke(new Object[]{port});
            if (tmp instanceof Boolean) {
                result = (Boolean)tmp;
            }
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return result;
    }

    public int getLowPort() {
        int result = -1;
        try {
            Object tmp = SubmodelClient.getProperty(this.submodel, "lowPort").getValue();
            if (tmp instanceof Integer) {
                result = (Integer)tmp;
            }
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return result;
    }

    public int getHighPort() {
        int result = -1;
        try {
            Object tmp = SubmodelClient.getProperty(this.submodel, "highPort").getValue();
            if (tmp instanceof Integer) {
                result = (Integer)tmp;
            }
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return result;
    }

    public void registerInstance(String key, String hostId) {
        try {
            NetworkManagerAasClient.checkKey((String)key);
            SubmodelClient.getOperation(this.submodel, "registerInstance").invoke(new Object[]{key, hostId});
        }
        catch (ExecutionException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void unregisterInstance(String key, String hostId) {
        try {
            NetworkManagerAasClient.checkKey((String)key);
            SubmodelClient.getOperation(this.submodel, "unregisterInstance").invoke(new Object[]{key, hostId});
        }
        catch (ExecutionException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public int getRegisteredInstances(String key) {
        int result = 0;
        try {
            NetworkManagerAasClient.checkKey((String)key);
            Object tmp = SubmodelClient.getOperation(this.submodel, "getRegisteredInstances").invoke(new Object[]{key});
            if (tmp instanceof Integer) {
                result = (Integer)tmp;
            }
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return result;
    }
}

