/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.iip_aas;

import de.iip_ecosphere.platform.support.aas.Operation;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.Submodel;
import java.util.concurrent.ExecutionException;

public class SubmodelClient {
    private Submodel submodel;
    private boolean refreshRequested;

    protected SubmodelClient(Submodel submodel) {
        this.submodel = submodel;
    }

    public Submodel getSubmodel() {
        if (this.refreshRequested) {
            this.submodel.refreshOnUse();
        }
        return this.submodel;
    }

    public void requestRefresh() {
        this.refreshRequested = true;
    }

    protected Operation getOperation(String idShort) throws ExecutionException {
        return SubmodelClient.getOperation(this.submodel, idShort);
    }

    public void clear() {
    }

    protected Property getProperty(String idShort) throws ExecutionException {
        return SubmodelClient.getProperty(this.submodel, idShort);
    }

    public static Operation getOperation(Submodel submodel, String idShort) throws ExecutionException {
        Operation result = submodel.getOperation(idShort);
        if (null == result) {
            throw new ExecutionException("Operation '" + idShort + "' not found", null);
        }
        return result;
    }

    public static Property getProperty(Submodel submodel, String idShort) throws ExecutionException {
        Property result = submodel.getProperty(idShort);
        if (null == result) {
            throw new ExecutionException("Property '" + idShort + "' not found", null);
        }
        return result;
    }

    protected String getPropertyStringValue(String name, String dflt) {
        String result = dflt;
        try {
            result = this.getProperty(name).getValue().toString();
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return result;
    }

    public static String checkString(Object obj) {
        String result;
        String string = result = null == obj ? null : obj.toString();
        if (null == result || result.length() == 0) {
            throw new IllegalArgumentException("Not valid string/response");
        }
        return result;
    }

    public static <T> T checkNotNull(T obj) {
        if (null == obj) {
            throw new IllegalArgumentException("No valid object");
        }
        return obj;
    }
}

