/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.iip_aas.config;

import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.iip_aas.config.ServerAddressHolder;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.net.KeyStoreDescriptor;
import java.io.File;
import java.io.IOException;

public class TlsServerAddressHolder
extends ServerAddressHolder {
    private File keystore;
    private String keyPassword;
    private String keystoreKey;
    private String keyAlias;
    private boolean appliesToClient = true;
    private boolean hostnameVerification = true;

    public TlsServerAddressHolder() {
    }

    public TlsServerAddressHolder(Schema schema, String host, int port) {
        super(schema, host, port);
    }

    public TlsServerAddressHolder(ServerAddress addr) {
        super(addr);
    }

    public TlsServerAddressHolder(TlsServerAddressHolder holder) {
        super(holder);
        this.keyAlias = holder.keyAlias;
        this.keyPassword = holder.keyPassword;
        this.keystoreKey = holder.keystoreKey;
        this.keystore = holder.keystore;
    }

    public File getKeystore() {
        return this.keystore;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public String getKeystoreKey() {
        return this.keystoreKey;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public boolean getAppliesToClient() {
        return this.appliesToClient;
    }

    public boolean getHostnameVerification() {
        return this.hostnameVerification;
    }

    public void setKeystore(File keystore) {
        this.keystore = keystore;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public void setKeystoreKey(String keystoreKey) {
        this.keystoreKey = keystoreKey;
    }

    public void setKeyAlias(String alias) {
        this.keyAlias = alias;
    }

    public void setAppliesToClient(boolean appliesToClient) {
        this.appliesToClient = appliesToClient;
    }

    public void setHostnameVerification(boolean hostnameVerification) {
        this.hostnameVerification = hostnameVerification;
    }

    public KeyStoreDescriptor getKeystoreDescriptor() {
        KeyStoreDescriptor result = null;
        if (null != this.keystoreKey) {
            try {
                result = KeyStoreDescriptor.create((String)this.keystoreKey, (String)this.keyAlias, (boolean)this.appliesToClient, (boolean)this.hostnameVerification);
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).warn("Cannot obtain keystore via keystore key '{}' due to {}. Trying to obtain keystore directly.", (Object)this.keystoreKey, (Object)e.getMessage());
            }
        }
        if (null != this.keystore && null == result) {
            result = new KeyStoreDescriptor(this.keystore, this.keyPassword, this.keyAlias, this.appliesToClient, this.hostnameVerification);
        }
        return result;
    }
}

