/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.codec;

import java.nio.ByteBuffer;
import org.apache.qpid.server.protocol.v1_0.codec.SimpleVariableWidthWriter;
import org.apache.qpid.server.protocol.v1_0.codec.ValueWriter;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;

public class SymbolArrayWriter
extends SimpleVariableWidthWriter<Symbol[]> {
    private static final ValueWriter.Factory<Symbol[]> FACTORY = new ValueWriter.Factory<Symbol[]>(){

        @Override
        public ValueWriter<Symbol[]> newInstance(ValueWriter.Registry registry, Symbol[] object) {
            return new SymbolArrayWriter(object);
        }
    };

    private SymbolArrayWriter(Symbol[] object) {
        super(SymbolArrayWriter.getEncodedValue(object));
    }

    @Override
    protected byte getFourOctetEncodingCode() {
        return -16;
    }

    @Override
    protected byte getSingleOctetEncodingCode() {
        return -32;
    }

    private static byte[] getEncodedValue(Symbol[] value) {
        boolean useSmallConstructor = SymbolArrayWriter.useSmallConstructor(value);
        boolean isSmall = useSmallConstructor && SymbolArrayWriter.canFitInSmall(value);
        int length = isSmall ? 2 : 5;
        for (Symbol symbol : value) {
            length += symbol.length();
        }
        byte[] encodedVal = new byte[length += value.length * (useSmallConstructor ? 1 : 4)];
        ByteBuffer buf = ByteBuffer.wrap(encodedVal);
        if (isSmall) {
            buf.put((byte)value.length);
            buf.put((byte)-93);
        } else {
            buf.putInt(value.length);
            buf.put((byte)-77);
        }
        for (Symbol symbol : value) {
            if (isSmall) {
                buf.put((byte)symbol.length());
            } else {
                buf.putInt(symbol.length());
            }
            for (int i = 0; i < symbol.length(); ++i) {
                buf.put((byte)symbol.charAt(i));
            }
        }
        return encodedVal;
    }

    private static boolean useSmallConstructor(Symbol[] value) {
        for (Symbol sym : value) {
            if (sym.length() <= 255) continue;
            return false;
        }
        return true;
    }

    private static boolean canFitInSmall(Symbol[] value) {
        if (value.length >= 127) {
            return false;
        }
        int remaining = 253 - value.length;
        for (Symbol symbol : value) {
            if ((remaining -= symbol.length()) >= 0) continue;
            return false;
        }
        return true;
    }

    public static void register(ValueWriter.Registry registry) {
        registry.register(Symbol[].class, FACTORY);
    }
}

