/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.openapi.models.V1EndpointAddress;
import io.kubernetes.client.openapi.models.V1EndpointAddressBuilder;
import io.kubernetes.client.openapi.models.V1EndpointAddressFluentImpl;
import io.kubernetes.client.openapi.models.V1EndpointPort;
import io.kubernetes.client.openapi.models.V1EndpointPortBuilder;
import io.kubernetes.client.openapi.models.V1EndpointPortFluentImpl;
import io.kubernetes.client.openapi.models.V1EndpointSubset;
import io.kubernetes.client.openapi.models.V1EndpointSubsetFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class V1EndpointSubsetFluentImpl<A extends V1EndpointSubsetFluent<A>>
extends BaseFluent<A>
implements V1EndpointSubsetFluent<A> {
    private List<V1EndpointAddressBuilder> addresses;
    private List<V1EndpointAddressBuilder> notReadyAddresses;
    private List<V1EndpointPortBuilder> ports;

    public V1EndpointSubsetFluentImpl() {
    }

    public V1EndpointSubsetFluentImpl(V1EndpointSubset instance) {
        this.withAddresses(instance.getAddresses());
        this.withNotReadyAddresses(instance.getNotReadyAddresses());
        this.withPorts(instance.getPorts());
    }

    @Override
    public A addToAddresses(int index, V1EndpointAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<V1EndpointAddressBuilder>();
        }
        V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);
        this._visitables.get("addresses").add(index >= 0 ? index : this._visitables.get("addresses").size(), builder);
        this.addresses.add(index >= 0 ? index : this.addresses.size(), builder);
        return (A)this;
    }

    @Override
    public A setToAddresses(int index, V1EndpointAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<V1EndpointAddressBuilder>();
        }
        V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);
        if (index < 0 || index >= this._visitables.get("addresses").size()) {
            this._visitables.get("addresses").add(builder);
        } else {
            this._visitables.get("addresses").set(index, builder);
        }
        if (index < 0 || index >= this.addresses.size()) {
            this.addresses.add(builder);
        } else {
            this.addresses.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAddresses(V1EndpointAddress ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<V1EndpointAddressBuilder>();
        }
        for (V1EndpointAddress item : items) {
            V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAddresses(Collection<V1EndpointAddress> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<V1EndpointAddressBuilder>();
        }
        for (V1EndpointAddress item : items) {
            V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);
            this._visitables.get("addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAddresses(V1EndpointAddress ... items) {
        for (V1EndpointAddress item : items) {
            V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);
            this._visitables.get("addresses").remove(builder);
            if (this.addresses == null) continue;
            this.addresses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAddresses(Collection<V1EndpointAddress> items) {
        for (V1EndpointAddress item : items) {
            V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);
            this._visitables.get("addresses").remove(builder);
            if (this.addresses == null) continue;
            this.addresses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromAddresses(Predicate<V1EndpointAddressBuilder> predicate) {
        if (this.addresses == null) {
            return (A)this;
        }
        Iterator<V1EndpointAddressBuilder> each = this.addresses.iterator();
        Object visitables = this._visitables.get("addresses");
        while (each.hasNext()) {
            V1EndpointAddressBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1EndpointAddress> getAddresses() {
        return V1EndpointSubsetFluentImpl.build(this.addresses);
    }

    @Override
    public List<V1EndpointAddress> buildAddresses() {
        return V1EndpointSubsetFluentImpl.build(this.addresses);
    }

    @Override
    public V1EndpointAddress buildAddress(int index) {
        return this.addresses.get(index).build();
    }

    @Override
    public V1EndpointAddress buildFirstAddress() {
        return this.addresses.get(0).build();
    }

    @Override
    public V1EndpointAddress buildLastAddress() {
        return this.addresses.get(this.addresses.size() - 1).build();
    }

    @Override
    public V1EndpointAddress buildMatchingAddress(Predicate<V1EndpointAddressBuilder> predicate) {
        for (V1EndpointAddressBuilder item : this.addresses) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAddress(Predicate<V1EndpointAddressBuilder> predicate) {
        for (V1EndpointAddressBuilder item : this.addresses) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAddresses(List<V1EndpointAddress> addresses) {
        if (this.addresses != null) {
            this._visitables.get("addresses").removeAll(this.addresses);
        }
        if (addresses != null) {
            this.addresses = new ArrayList<V1EndpointAddressBuilder>();
            for (V1EndpointAddress item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = null;
        }
        return (A)this;
    }

    @Override
    public A withAddresses(V1EndpointAddress ... addresses) {
        if (this.addresses != null) {
            this.addresses.clear();
        }
        if (addresses != null) {
            for (V1EndpointAddress item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    @Override
    public V1EndpointSubsetFluent.AddressesNested<A> addNewAddress() {
        return new AddressesNestedImpl();
    }

    @Override
    public V1EndpointSubsetFluent.AddressesNested<A> addNewAddressLike(V1EndpointAddress item) {
        return new AddressesNestedImpl(-1, item);
    }

    @Override
    public V1EndpointSubsetFluent.AddressesNested<A> setNewAddressLike(int index, V1EndpointAddress item) {
        return new AddressesNestedImpl(index, item);
    }

    @Override
    public V1EndpointSubsetFluent.AddressesNested<A> editAddress(int index) {
        if (this.addresses.size() <= index) {
            throw new RuntimeException("Can't edit addresses. Index exceeds size.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    @Override
    public V1EndpointSubsetFluent.AddressesNested<A> editFirstAddress() {
        if (this.addresses.size() == 0) {
            throw new RuntimeException("Can't edit first addresses. The list is empty.");
        }
        return this.setNewAddressLike(0, this.buildAddress(0));
    }

    @Override
    public V1EndpointSubsetFluent.AddressesNested<A> editLastAddress() {
        int index = this.addresses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last addresses. The list is empty.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    @Override
    public V1EndpointSubsetFluent.AddressesNested<A> editMatchingAddress(Predicate<V1EndpointAddressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.addresses.size(); ++i) {
            if (!predicate.apply(this.addresses.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching addresses. No match found.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    @Override
    public A addToNotReadyAddresses(int index, V1EndpointAddress item) {
        if (this.notReadyAddresses == null) {
            this.notReadyAddresses = new ArrayList<V1EndpointAddressBuilder>();
        }
        V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);
        this._visitables.get("notReadyAddresses").add(index >= 0 ? index : this._visitables.get("notReadyAddresses").size(), builder);
        this.notReadyAddresses.add(index >= 0 ? index : this.notReadyAddresses.size(), builder);
        return (A)this;
    }

    @Override
    public A setToNotReadyAddresses(int index, V1EndpointAddress item) {
        if (this.notReadyAddresses == null) {
            this.notReadyAddresses = new ArrayList<V1EndpointAddressBuilder>();
        }
        V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);
        if (index < 0 || index >= this._visitables.get("notReadyAddresses").size()) {
            this._visitables.get("notReadyAddresses").add(builder);
        } else {
            this._visitables.get("notReadyAddresses").set(index, builder);
        }
        if (index < 0 || index >= this.notReadyAddresses.size()) {
            this.notReadyAddresses.add(builder);
        } else {
            this.notReadyAddresses.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToNotReadyAddresses(V1EndpointAddress ... items) {
        if (this.notReadyAddresses == null) {
            this.notReadyAddresses = new ArrayList<V1EndpointAddressBuilder>();
        }
        for (V1EndpointAddress item : items) {
            V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);
            this._visitables.get("notReadyAddresses").add(builder);
            this.notReadyAddresses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToNotReadyAddresses(Collection<V1EndpointAddress> items) {
        if (this.notReadyAddresses == null) {
            this.notReadyAddresses = new ArrayList<V1EndpointAddressBuilder>();
        }
        for (V1EndpointAddress item : items) {
            V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);
            this._visitables.get("notReadyAddresses").add(builder);
            this.notReadyAddresses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromNotReadyAddresses(V1EndpointAddress ... items) {
        for (V1EndpointAddress item : items) {
            V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);
            this._visitables.get("notReadyAddresses").remove(builder);
            if (this.notReadyAddresses == null) continue;
            this.notReadyAddresses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNotReadyAddresses(Collection<V1EndpointAddress> items) {
        for (V1EndpointAddress item : items) {
            V1EndpointAddressBuilder builder = new V1EndpointAddressBuilder(item);
            this._visitables.get("notReadyAddresses").remove(builder);
            if (this.notReadyAddresses == null) continue;
            this.notReadyAddresses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromNotReadyAddresses(Predicate<V1EndpointAddressBuilder> predicate) {
        if (this.notReadyAddresses == null) {
            return (A)this;
        }
        Iterator<V1EndpointAddressBuilder> each = this.notReadyAddresses.iterator();
        Object visitables = this._visitables.get("notReadyAddresses");
        while (each.hasNext()) {
            V1EndpointAddressBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1EndpointAddress> getNotReadyAddresses() {
        return V1EndpointSubsetFluentImpl.build(this.notReadyAddresses);
    }

    @Override
    public List<V1EndpointAddress> buildNotReadyAddresses() {
        return V1EndpointSubsetFluentImpl.build(this.notReadyAddresses);
    }

    @Override
    public V1EndpointAddress buildNotReadyAddress(int index) {
        return this.notReadyAddresses.get(index).build();
    }

    @Override
    public V1EndpointAddress buildFirstNotReadyAddress() {
        return this.notReadyAddresses.get(0).build();
    }

    @Override
    public V1EndpointAddress buildLastNotReadyAddress() {
        return this.notReadyAddresses.get(this.notReadyAddresses.size() - 1).build();
    }

    @Override
    public V1EndpointAddress buildMatchingNotReadyAddress(Predicate<V1EndpointAddressBuilder> predicate) {
        for (V1EndpointAddressBuilder item : this.notReadyAddresses) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingNotReadyAddress(Predicate<V1EndpointAddressBuilder> predicate) {
        for (V1EndpointAddressBuilder item : this.notReadyAddresses) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withNotReadyAddresses(List<V1EndpointAddress> notReadyAddresses) {
        if (this.notReadyAddresses != null) {
            this._visitables.get("notReadyAddresses").removeAll(this.notReadyAddresses);
        }
        if (notReadyAddresses != null) {
            this.notReadyAddresses = new ArrayList<V1EndpointAddressBuilder>();
            for (V1EndpointAddress item : notReadyAddresses) {
                this.addToNotReadyAddresses(item);
            }
        } else {
            this.notReadyAddresses = null;
        }
        return (A)this;
    }

    @Override
    public A withNotReadyAddresses(V1EndpointAddress ... notReadyAddresses) {
        if (this.notReadyAddresses != null) {
            this.notReadyAddresses.clear();
        }
        if (notReadyAddresses != null) {
            for (V1EndpointAddress item : notReadyAddresses) {
                this.addToNotReadyAddresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNotReadyAddresses() {
        return this.notReadyAddresses != null && !this.notReadyAddresses.isEmpty();
    }

    @Override
    public V1EndpointSubsetFluent.NotReadyAddressesNested<A> addNewNotReadyAddress() {
        return new NotReadyAddressesNestedImpl();
    }

    @Override
    public V1EndpointSubsetFluent.NotReadyAddressesNested<A> addNewNotReadyAddressLike(V1EndpointAddress item) {
        return new NotReadyAddressesNestedImpl(-1, item);
    }

    @Override
    public V1EndpointSubsetFluent.NotReadyAddressesNested<A> setNewNotReadyAddressLike(int index, V1EndpointAddress item) {
        return new NotReadyAddressesNestedImpl(index, item);
    }

    @Override
    public V1EndpointSubsetFluent.NotReadyAddressesNested<A> editNotReadyAddress(int index) {
        if (this.notReadyAddresses.size() <= index) {
            throw new RuntimeException("Can't edit notReadyAddresses. Index exceeds size.");
        }
        return this.setNewNotReadyAddressLike(index, this.buildNotReadyAddress(index));
    }

    @Override
    public V1EndpointSubsetFluent.NotReadyAddressesNested<A> editFirstNotReadyAddress() {
        if (this.notReadyAddresses.size() == 0) {
            throw new RuntimeException("Can't edit first notReadyAddresses. The list is empty.");
        }
        return this.setNewNotReadyAddressLike(0, this.buildNotReadyAddress(0));
    }

    @Override
    public V1EndpointSubsetFluent.NotReadyAddressesNested<A> editLastNotReadyAddress() {
        int index = this.notReadyAddresses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last notReadyAddresses. The list is empty.");
        }
        return this.setNewNotReadyAddressLike(index, this.buildNotReadyAddress(index));
    }

    @Override
    public V1EndpointSubsetFluent.NotReadyAddressesNested<A> editMatchingNotReadyAddress(Predicate<V1EndpointAddressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.notReadyAddresses.size(); ++i) {
            if (!predicate.apply(this.notReadyAddresses.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching notReadyAddresses. No match found.");
        }
        return this.setNewNotReadyAddressLike(index, this.buildNotReadyAddress(index));
    }

    @Override
    public A addToPorts(int index, V1EndpointPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList<V1EndpointPortBuilder>();
        }
        V1EndpointPortBuilder builder = new V1EndpointPortBuilder(item);
        this._visitables.get("ports").add(index >= 0 ? index : this._visitables.get("ports").size(), builder);
        this.ports.add(index >= 0 ? index : this.ports.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPorts(int index, V1EndpointPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList<V1EndpointPortBuilder>();
        }
        V1EndpointPortBuilder builder = new V1EndpointPortBuilder(item);
        if (index < 0 || index >= this._visitables.get("ports").size()) {
            this._visitables.get("ports").add(builder);
        } else {
            this._visitables.get("ports").set(index, builder);
        }
        if (index < 0 || index >= this.ports.size()) {
            this.ports.add(builder);
        } else {
            this.ports.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPorts(V1EndpointPort ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList<V1EndpointPortBuilder>();
        }
        for (V1EndpointPort item : items) {
            V1EndpointPortBuilder builder = new V1EndpointPortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPorts(Collection<V1EndpointPort> items) {
        if (this.ports == null) {
            this.ports = new ArrayList<V1EndpointPortBuilder>();
        }
        for (V1EndpointPort item : items) {
            V1EndpointPortBuilder builder = new V1EndpointPortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPorts(V1EndpointPort ... items) {
        for (V1EndpointPort item : items) {
            V1EndpointPortBuilder builder = new V1EndpointPortBuilder(item);
            this._visitables.get("ports").remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPorts(Collection<V1EndpointPort> items) {
        for (V1EndpointPort item : items) {
            V1EndpointPortBuilder builder = new V1EndpointPortBuilder(item);
            this._visitables.get("ports").remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromPorts(Predicate<V1EndpointPortBuilder> predicate) {
        if (this.ports == null) {
            return (A)this;
        }
        Iterator<V1EndpointPortBuilder> each = this.ports.iterator();
        Object visitables = this._visitables.get("ports");
        while (each.hasNext()) {
            V1EndpointPortBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1EndpointPort> getPorts() {
        return V1EndpointSubsetFluentImpl.build(this.ports);
    }

    @Override
    public List<V1EndpointPort> buildPorts() {
        return V1EndpointSubsetFluentImpl.build(this.ports);
    }

    @Override
    public V1EndpointPort buildPort(int index) {
        return this.ports.get(index).build();
    }

    @Override
    public V1EndpointPort buildFirstPort() {
        return this.ports.get(0).build();
    }

    @Override
    public V1EndpointPort buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    @Override
    public V1EndpointPort buildMatchingPort(Predicate<V1EndpointPortBuilder> predicate) {
        for (V1EndpointPortBuilder item : this.ports) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPort(Predicate<V1EndpointPortBuilder> predicate) {
        for (V1EndpointPortBuilder item : this.ports) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPorts(List<V1EndpointPort> ports) {
        if (this.ports != null) {
            this._visitables.get("ports").removeAll(this.ports);
        }
        if (ports != null) {
            this.ports = new ArrayList<V1EndpointPortBuilder>();
            for (V1EndpointPort item : ports) {
                this.addToPorts(item);
            }
        } else {
            this.ports = null;
        }
        return (A)this;
    }

    @Override
    public A withPorts(V1EndpointPort ... ports) {
        if (this.ports != null) {
            this.ports.clear();
        }
        if (ports != null) {
            for (V1EndpointPort item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    @Override
    public V1EndpointSubsetFluent.PortsNested<A> addNewPort() {
        return new PortsNestedImpl();
    }

    @Override
    public V1EndpointSubsetFluent.PortsNested<A> addNewPortLike(V1EndpointPort item) {
        return new PortsNestedImpl(-1, item);
    }

    @Override
    public V1EndpointSubsetFluent.PortsNested<A> setNewPortLike(int index, V1EndpointPort item) {
        return new PortsNestedImpl(index, item);
    }

    @Override
    public V1EndpointSubsetFluent.PortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public V1EndpointSubsetFluent.PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    @Override
    public V1EndpointSubsetFluent.PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public V1EndpointSubsetFluent.PortsNested<A> editMatchingPort(Predicate<V1EndpointPortBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.apply(this.ports.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1EndpointSubsetFluentImpl that = (V1EndpointSubsetFluentImpl)o;
        if (this.addresses != null ? !this.addresses.equals(that.addresses) : that.addresses != null) {
            return false;
        }
        if (this.notReadyAddresses != null ? !this.notReadyAddresses.equals(that.notReadyAddresses) : that.notReadyAddresses != null) {
            return false;
        }
        return !(this.ports != null ? !this.ports.equals(that.ports) : that.ports != null);
    }

    public class PortsNestedImpl<N>
    extends V1EndpointPortFluentImpl<V1EndpointSubsetFluent.PortsNested<N>>
    implements V1EndpointSubsetFluent.PortsNested<N>,
    Nested<N> {
        private final V1EndpointPortBuilder builder;
        private final int index;

        PortsNestedImpl(int index, V1EndpointPort item) {
            this.index = index;
            this.builder = new V1EndpointPortBuilder(this, item);
        }

        PortsNestedImpl() {
            this.index = -1;
            this.builder = new V1EndpointPortBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1EndpointSubsetFluentImpl.this.setToPorts(this.index, this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }

    public class NotReadyAddressesNestedImpl<N>
    extends V1EndpointAddressFluentImpl<V1EndpointSubsetFluent.NotReadyAddressesNested<N>>
    implements V1EndpointSubsetFluent.NotReadyAddressesNested<N>,
    Nested<N> {
        private final V1EndpointAddressBuilder builder;
        private final int index;

        NotReadyAddressesNestedImpl(int index, V1EndpointAddress item) {
            this.index = index;
            this.builder = new V1EndpointAddressBuilder(this, item);
        }

        NotReadyAddressesNestedImpl() {
            this.index = -1;
            this.builder = new V1EndpointAddressBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1EndpointSubsetFluentImpl.this.setToNotReadyAddresses(this.index, this.builder.build());
        }

        @Override
        public N endNotReadyAddress() {
            return this.and();
        }
    }

    public class AddressesNestedImpl<N>
    extends V1EndpointAddressFluentImpl<V1EndpointSubsetFluent.AddressesNested<N>>
    implements V1EndpointSubsetFluent.AddressesNested<N>,
    Nested<N> {
        private final V1EndpointAddressBuilder builder;
        private final int index;

        AddressesNestedImpl(int index, V1EndpointAddress item) {
            this.index = index;
            this.builder = new V1EndpointAddressBuilder(this, item);
        }

        AddressesNestedImpl() {
            this.index = -1;
            this.builder = new V1EndpointAddressBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1EndpointSubsetFluentImpl.this.setToAddresses(this.index, this.builder.build());
        }

        @Override
        public N endAddress() {
            return this.and();
        }
    }
}

