/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.resources;

import de.iip_ecosphere.platform.support.jsl.ServiceLoaderUtils;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.plugins.PluginSetup;
import de.iip_ecosphere.platform.support.resources.MavenResourceResolver;
import de.iip_ecosphere.platform.support.resources.MultiResourceResolver;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Predicate;

public class ResourceLoader {
    public static final ResourceResolver MAVEN_RESOLVER = new MavenResourceResolver();
    private static List<ResourceResolver> resolvers = new ArrayList<ResourceResolver>();
    private static List<Predicate<URI>> filters = null;

    public static void registerResourceResolver(ResourceResolver resolver) {
        ResourceLoader.registerResourceResolver(resolver, false);
    }

    public static void registerResourceResolver(ResourceResolver resolver, boolean prepend) {
        if (null != resolver) {
            if (prepend) {
                resolvers.add(0, resolver);
            } else {
                resolvers.add(resolver);
            }
            LoggerFactory.getLogger(ResourceLoader.class).info("Registered resource resolver {}", (Object)resolver.getName());
        }
    }

    public static boolean knowsResourceResolver(ResourceResolver resolver) {
        return resolvers.contains(resolver);
    }

    public static void unregisterResourceResolver(ResourceResolver resolver) {
        if (null != resolver) {
            resolvers.remove(resolver);
            LoggerFactory.getLogger(PluginSetup.getClassLoader()).info("Unregistered resource resolver {}", (Object)resolver.getName());
        }
    }

    public static InputStream getResourceAsStream(String name, ResourceResolver ... optional) {
        return ResourceLoader.getResourceAsStream(PluginSetup.getClassLoader(), name, optional);
    }

    public static ResourceResolver getAllRegisteredResolver(ResourceResolver ... resolver) {
        List<ResourceResolver> res;
        if (resolver.length > 0) {
            res = new ArrayList<ResourceResolver>();
            res.addAll(resolvers);
            for (ResourceResolver r : resolver) {
                res.add(r);
            }
        } else {
            res = resolvers;
        }
        return new MultiResourceResolver(res);
    }

    public static InputStream getResourceAsStream(Class<?> cls, String name, ResourceResolver ... optional) {
        return ResourceLoader.getResourceAsStream(cls.getClassLoader(), name, optional);
    }

    public static InputStream getResourceAsStream(ClassLoader loader, String name, ResourceResolver ... optional) {
        InputStream result = null;
        while (name.startsWith("/")) {
            name = name.substring(1);
        }
        List<ResourceResolver> res = resolvers;
        if (null != optional && optional.length > 0) {
            res = new ArrayList<ResourceResolver>();
            res.addAll(resolvers);
            Collections.addAll(res, optional);
        }
        for (ResourceResolver r : res) {
            result = r.resolve(loader, name);
            if (result != null) {
                LoggerFactory.getLogger(ResourceLoader.class).info("Loading resource '{}' via {}", (Object)name, (Object)r.getName());
                break;
            }
            if (null == result && !name.startsWith("/")) {
                result = r.resolve(loader, "/" + name);
            }
            if (result == null) continue;
            LoggerFactory.getLogger(ResourceLoader.class).info("Loading {} via {}", (Object)name, (Object)r.getName());
            break;
        }
        if (null == result) {
            LoggerFactory.getLogger(ResourceLoader.class).debug("Resource {} not found", (Object)name);
        }
        return result;
    }

    public static final String prependSlash(String text) {
        if (!text.startsWith("/")) {
            text = "/" + text;
        }
        return text;
    }

    public static void addFilter(Predicate<URI> filter) {
        if (null != filter) {
            if (null == filters) {
                filters = new ArrayList<Predicate<URI>>();
            }
            filters.add(filter);
        }
    }

    public static void clearFilters() {
        filters = null;
    }

    public static void addTestExcludeFilters() {
        ResourceLoader.addFilter(u -> !u.toString().endsWith("-tests.jar!/identityStore.yml"));
    }

    public static boolean hasFilters() {
        return null != filters && !filters.isEmpty();
    }

    public static boolean matchesFilter(URI uri) {
        boolean matches = true;
        if (null != filters) {
            for (int f = 0; matches && f < filters.size(); ++f) {
                matches = filters.get(f).test(uri);
            }
        }
        return matches;
    }

    static {
        ResourceLoader.registerResourceResolver(new ResourceResolver(){

            @Override
            public String getName() {
                return "Classloader";
            }

            @Override
            public InputStream resolve(ClassLoader loader, String resource) {
                InputStream result = null;
                if (ResourceLoader.hasFilters()) {
                    try {
                        Enumeration<URL> res = loader.getResources(resource);
                        while (res.hasMoreElements()) {
                            URL u = res.nextElement();
                            try {
                                if (!ResourceLoader.matchesFilter(u.toURI())) continue;
                                result = u.openStream();
                            }
                            catch (URISyntaxException e) {
                                LoggerFactory.getLogger(this).warn("Cannot filter resource URL {}: {}", (Object)u, (Object)e.getMessage());
                            }
                        }
                    }
                    catch (IOException e) {
                        LoggerFactory.getLogger(this).warn("Cannot enumerate resources for {}: {}", (Object)resource, (Object)e.getMessage());
                    }
                } else {
                    result = loader.getResourceAsStream(resource);
                }
                return result;
            }
        });
        ServiceLoader<ResourceResolver> loader = ServiceLoaderUtils.load(ResourceResolver.class);
        if (null != loader) {
            loader.forEach(r -> ResourceLoader.registerResourceResolver(r));
        }
    }
}

