/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.factory.aasx;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.file.FileAlreadyExistsException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.InvalidOperationException;
import org.apache.poi.openxml4j.opc.ContentTypes;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.openxml4j.opc.RelationshipSource;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.openxml4j.opc.internal.MemoryPackagePart;
import org.eclipse.basyx.aas.factory.aasx.InMemoryFile;
import org.eclipse.basyx.aas.factory.aasx.Thumbnail;
import org.eclipse.basyx.aas.factory.exception.MultipleThumbnailFoundException;
import org.eclipse.basyx.aas.factory.xml.MetamodelToXMLConverter;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.aas.metamodel.api.parts.asset.IAsset;
import org.eclipse.basyx.aas.metamodel.map.AasEnv;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.parts.IConceptDescription;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElementCollection;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.dataelement.File;
import org.eclipse.basyx.vab.exception.provider.ResourceNotFoundException;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetamodelToAASXConverter {
    private static Logger logger = LoggerFactory.getLogger(MetamodelToAASXConverter.class);
    private static final String MIME_PLAINTXT = "text/plain";
    private static final String MIME_XML = "application/xml";
    private static final String ORIGIN_RELTYPE = "http://www.admin-shell.io/aasx/relationships/aasx-origin";
    private static final String ORIGIN_PATH = "/aasx/aasx-origin";
    private static final String ORIGIN_CONTENT = "Intentionally empty.";
    private static final String AASSPEC_RELTYPE = "http://www.admin-shell.io/aasx/relationships/aas-spec";
    private static final String XML_PATH = "/aasx/xml/content.xml";
    private static final String AASSUPPL_RELTYPE = "http://www.admin-shell.io/aasx/relationships/aas-suppl";
    protected static final String THUMBNAIL_TYPE = "http://schemas.openxmlformats.org/package/2006/relationships/metadata/thumbnail";

    public static void buildAASX(Collection<IAssetAdministrationShell> aasList, Collection<IAsset> assetList, Collection<IConceptDescription> conceptDescriptionList, Collection<ISubmodel> submodelList, Collection<InMemoryFile> files, OutputStream os) throws IOException, TransformerException, ParserConfigurationException {
        MetamodelToAASXConverter.buildAASX(aasList, assetList, conceptDescriptionList, submodelList, files, null, os);
    }

    public static void buildAASX(AasEnv aasEnv, Collection<InMemoryFile> files, OutputStream os) throws IOException, TransformerException, ParserConfigurationException {
        MetamodelToAASXConverter.buildAASX(aasEnv.getAssetAdministrationShells(), aasEnv.getAssets(), aasEnv.getConceptDescriptions(), aasEnv.getSubmodels(), files, os);
    }

    public static void buildAASX(AasEnv aasEnv, Collection<InMemoryFile> files, Thumbnail thumbnail, OutputStream os) throws IOException, TransformerException, ParserConfigurationException {
        MetamodelToAASXConverter.buildAASX(aasEnv.getAssetAdministrationShells(), aasEnv.getAssets(), aasEnv.getConceptDescriptions(), aasEnv.getSubmodels(), files, thumbnail, os);
    }

    public static void buildAASX(Collection<IAssetAdministrationShell> aasList, Collection<IAsset> assetList, Collection<IConceptDescription> conceptDescriptionList, Collection<ISubmodel> submodelList, Collection<InMemoryFile> files, Thumbnail thumbnail, OutputStream os) throws TransformerException, ParserConfigurationException, IOException {
        MetamodelToAASXConverter.prepareFilePaths(submodelList, files);
        OPCPackage rootPackage = OPCPackage.create((OutputStream)os);
        PackagePart origin = MetamodelToAASXConverter.createAASXPart(rootPackage, (RelationshipSource)rootPackage, ORIGIN_PATH, MIME_PLAINTXT, ORIGIN_RELTYPE, ORIGIN_CONTENT.getBytes());
        String xml = MetamodelToAASXConverter.convertToXML(aasList, assetList, conceptDescriptionList, submodelList);
        PackagePart xmlPart = MetamodelToAASXConverter.createAASXPart(rootPackage, (RelationshipSource)origin, XML_PATH, MIME_XML, AASSPEC_RELTYPE, xml.getBytes());
        MetamodelToAASXConverter.storeFilesInAASX(submodelList, files, rootPackage, xmlPart);
        MetamodelToAASXConverter.addThumbnail(thumbnail, rootPackage);
        MetamodelToAASXConverter.saveAASX(os, rootPackage);
    }

    public static void addThumbnail(Thumbnail thumbnail, OPCPackage rootPackage) throws IOException {
        if (!MetamodelToAASXConverter.isValid(thumbnail)) {
            logger.info("No thumbnail has been specified");
            return;
        }
        String name = MetamodelToAASXConverter.extractFilenameFromPath(thumbnail);
        MetamodelToAASXConverter.addThumbnail(name, thumbnail.getThumbnailStream(), rootPackage);
    }

    private static boolean isValid(Thumbnail thumbnail) {
        return thumbnail != null;
    }

    private static String extractFilenameFromPath(Thumbnail thumbnail) {
        return thumbnail.getThumbnailFilename().substring(thumbnail.getThumbnailFilename().lastIndexOf(java.io.File.separatorChar) + 1);
    }

    private static void addThumbnail(String filename, InputStream data, OPCPackage rootPackage) throws IOException {
        String contentType = ContentTypes.getContentTypeFromFileExtension((String)filename);
        PackagePartName thumbnailPartName = MetamodelToAASXConverter.createThumbnailPackagePartName(filename);
        MetamodelToAASXConverter.checkIfThumbnailAlreadyPresent(filename, rootPackage, thumbnailPartName);
        PackagePart thumbnailPart = MetamodelToAASXConverter.createAASXPart(rootPackage, thumbnailPartName, contentType);
        rootPackage.addRelationship(thumbnailPartName, TargetMode.EXTERNAL, THUMBNAIL_TYPE, MetamodelToAASXConverter.createUniqueID());
        MetamodelToAASXConverter.writeDataToPart(thumbnailPart, IOUtils.toByteArray((InputStream)data));
        rootPackage.registerPartAndContentType(thumbnailPart);
    }

    private static void checkIfThumbnailAlreadyPresent(String filename, OPCPackage rootPackage, PackagePartName thumbnailPartName) throws FileAlreadyExistsException, MultipleThumbnailFoundException {
        MetamodelToAASXConverter.checkIfSamePackagePartAlreadyExists(filename, rootPackage, thumbnailPartName);
        PackageRelationshipCollection thumbnailPackageRelationship = rootPackage.getRelationshipsByType(THUMBNAIL_TYPE);
        if (thumbnailPackageRelationship.size() > 1) {
            throw new MultipleThumbnailFoundException("More than one Thumbnail found in the specified package");
        }
        if (thumbnailPackageRelationship.size() == 1) {
            throw new FileAlreadyExistsException("Thumbnail already present in the specified package");
        }
    }

    private static void checkIfSamePackagePartAlreadyExists(String filename, OPCPackage rootPackage, PackagePartName thumbnailPartName) throws FileAlreadyExistsException {
        if (rootPackage.getPart(thumbnailPartName) != null) {
            throw new FileAlreadyExistsException("Thumbnail package part already exists with name '" + filename + "'");
        }
    }

    private static PackagePartName createThumbnailPackagePartName(String filename) {
        PackagePartName thumbnailPartName;
        try {
            thumbnailPartName = PackagingURIHelper.createPartName((String)("/" + FilenameUtils.getName((String)filename)));
        }
        catch (InvalidFormatException e) {
            throw new InvalidOperationException("Can't add a thumbnail file named '" + filename + "'", (Throwable)e);
        }
        return thumbnailPartName;
    }

    private static void storeFilesInAASX(Collection<ISubmodel> submodelList, Collection<InMemoryFile> files, OPCPackage rootPackage, PackagePart xmlPart) {
        for (ISubmodel sm : submodelList) {
            for (File file : MetamodelToAASXConverter.findFileElements(sm.getSubmodelElements().values())) {
                String filePath = file.getValue();
                MetamodelToAASXConverter.storeFileInAASX(files, rootPackage, xmlPart, file, filePath);
            }
        }
    }

    private static void storeFileInAASX(Collection<InMemoryFile> files, OPCPackage rootPackage, PackagePart xmlPart, File file, String filePath) {
        try {
            InMemoryFile content = MetamodelToAASXConverter.findFileByPath(files, filePath);
            logger.trace("Writing file '" + filePath + "' to .aasx.");
            MetamodelToAASXConverter.createAASXPart(rootPackage, (RelationshipSource)xmlPart, filePath, file.getMimeType(), AASSUPPL_RELTYPE, content.getFileContent());
        }
        catch (ResourceNotFoundException e) {
            logger.warn("Could not add File '" + filePath + "'. It was not contained in given InMemoryFiles.");
        }
    }

    private static void saveAASX(OutputStream os, OPCPackage rootPackage) throws IOException {
        rootPackage.flush();
        rootPackage.save(os);
    }

    private static String createUniqueID() {
        return "Rid_" + UUID.randomUUID().toString();
    }

    private static PackagePart createAASXPart(OPCPackage root, PackagePartName partName, String contentType) {
        if (partName == null) {
            throw new IllegalArgumentException("Partname shouldn't be null");
        }
        if (contentType == null || contentType.isEmpty()) {
            throw new IllegalArgumentException("No MIME_TYPE specified");
        }
        try {
            return new MemoryPackagePart(root, partName, contentType);
        }
        catch (InvalidFormatException e) {
            return null;
        }
    }

    private static PackagePart createAASXPart(OPCPackage root, RelationshipSource relateTo, String path, String mimeType, String relType, byte[] content) {
        if (mimeType == null || mimeType.equals("")) {
            throw new RuntimeException("Could not create AASX Part '" + path + "'. No MIME_TYPE specified.");
        }
        PackagePartName partName = null;
        MemoryPackagePart part = null;
        try {
            partName = PackagingURIHelper.createPartName((String)path);
            part = new MemoryPackagePart(root, partName, mimeType);
        }
        catch (InvalidFormatException e) {
            throw new RuntimeException("Could not create AASX Part '" + path + "'", e);
        }
        MetamodelToAASXConverter.writeDataToPart((PackagePart)part, content);
        root.registerPartAndContentType((PackagePart)part);
        relateTo.addRelationship(partName, TargetMode.EXTERNAL, relType, MetamodelToAASXConverter.createUniqueID());
        return part;
    }

    private static void writeDataToPart(PackagePart part, byte[] content) {
        try (OutputStream ostream = part.getOutputStream();){
            ostream.write(content);
            ostream.flush();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to write content to AASX Part '" + part.getPartName().getName() + "'", e);
        }
    }

    private static String convertToXML(Collection<IAssetAdministrationShell> aasList, Collection<IAsset> assetList, Collection<IConceptDescription> conceptDescriptionList, Collection<ISubmodel> submodelList) throws TransformerException, ParserConfigurationException {
        StringWriter writer = new StringWriter();
        MetamodelToXMLConverter.convertToXML(aasList, assetList, conceptDescriptionList, submodelList, new StreamResult(writer));
        return writer.toString();
    }

    private static Collection<File> findFileElements(Collection<ISubmodelElement> elements) {
        ArrayList<File> files = new ArrayList<File>();
        for (ISubmodelElement element : elements) {
            if (element instanceof File) {
                files.add((File)element);
                continue;
            }
            if (!(element instanceof SubmodelElementCollection)) continue;
            files.addAll(MetamodelToAASXConverter.findFileElements(((SubmodelElementCollection)element).getSubmodelElements().values()));
        }
        return files;
    }

    private static Collection<File> findInMemoryFileElements(Collection<ISubmodelElement> elements, Collection<InMemoryFile> inMemoryFiles) {
        Collection<File> files = MetamodelToAASXConverter.findFileElements(elements);
        return files.stream().filter(f -> MetamodelToAASXConverter.isInMemoryFile(inMemoryFiles, f.getValue())).collect(Collectors.toList());
    }

    private static void prepareFilePaths(Collection<ISubmodel> submodels, Collection<InMemoryFile> inMemoryFiles) {
        submodels.stream().forEach(sm -> MetamodelToAASXConverter.findInMemoryFileElements(sm.getSubmodelElements().values(), inMemoryFiles).stream().forEach(f -> f.setValue(MetamodelToAASXConverter.preparePath(f.getValue()))));
    }

    private static String preparePath(String path) {
        return VABPathTools.getPathFromURL(path);
    }

    private static InMemoryFile findFileByPath(Collection<InMemoryFile> files, String path) {
        for (InMemoryFile file : files) {
            if (!MetamodelToAASXConverter.preparePath(file.getPath()).equals(path)) continue;
            return file;
        }
        throw new ResourceNotFoundException("The wanted file '" + path + "' was not found in the given files.");
    }

    private static boolean isInMemoryFile(Collection<InMemoryFile> files, String path) {
        for (InMemoryFile file : files) {
            if (!VABPathTools.stripSlashes(file.getPath()).equals(VABPathTools.stripSlashes(path))) continue;
            return true;
        }
        return false;
    }
}

