/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.aas.registration.proxy;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.basyx.aas.metamodel.map.descriptor.AASDescriptor;
import org.eclipse.basyx.aas.metamodel.map.descriptor.SubmodelDescriptor;
import org.eclipse.basyx.aas.registration.AASRegistryAPIHelper;
import org.eclipse.basyx.aas.registration.api.IAASRegistry;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.vab.coder.json.connector.JSONConnector;
import org.eclipse.basyx.vab.exception.provider.ProviderException;
import org.eclipse.basyx.vab.modelprovider.VABElementProxy;
import org.eclipse.basyx.vab.modelprovider.api.IModelProvider;
import org.eclipse.basyx.vab.protocol.http.connector.HTTPConnector;
import org.eclipse.basyx.vab.protocol.https.HTTPSConnector;
import org.eclipse.basyx.vab.registry.proxy.VABRegistryProxy;

public class AASRegistryProxy
extends VABRegistryProxy
implements IAASRegistry {
    public AASRegistryProxy(String registryUrl) {
        this(AASRegistryProxy.getJSONConnectorWithProtocol(registryUrl));
    }

    private static JSONConnector getJSONConnectorWithProtocol(String registryUrl) {
        if (AASRegistryProxy.isHTTPSUrl(registryUrl)) {
            return new JSONConnector(new HTTPSConnector(AASRegistryProxy.harmonizeURL(registryUrl)));
        }
        return new JSONConnector(new HTTPConnector(AASRegistryProxy.harmonizeURL(registryUrl)));
    }

    protected static String harmonizeURL(String url) {
        if (url.endsWith("api/v1/registry")) {
            url = url.substring(0, url.length() - "api/v1/registry".length());
        }
        return url;
    }

    public AASRegistryProxy(IModelProvider provider) throws ProviderException {
        super(AASRegistryProxy.createProxy(provider));
    }

    private static VABElementProxy createProxy(IModelProvider provider) {
        return new VABElementProxy("", provider);
    }

    @Override
    public void register(AASDescriptor deviceAASDescriptor) throws ProviderException {
        try {
            String encodedId = AASRegistryAPIHelper.getAASPath(deviceAASDescriptor.getIdentifier());
            this.provider.setValue(encodedId, deviceAASDescriptor);
        }
        catch (Exception e) {
            if (e instanceof ProviderException) {
                throw (ProviderException)e;
            }
            throw new ProviderException(e);
        }
    }

    @Override
    public void delete(IIdentifier aasIdentifier) throws ProviderException {
        this.removeMapping(AASRegistryAPIHelper.getAASPath(aasIdentifier));
    }

    @Override
    public AASDescriptor lookupAAS(IIdentifier aasIdentifier) throws ProviderException {
        try {
            Object result = this.provider.getValue(AASRegistryAPIHelper.getAASPath(aasIdentifier));
            return new AASDescriptor((Map)result);
        }
        catch (Exception e) {
            if (e instanceof ProviderException) {
                throw (ProviderException)e;
            }
            throw new ProviderException(e);
        }
    }

    @Override
    public List<AASDescriptor> lookupAll() throws ProviderException {
        try {
            Object result = this.provider.getValue(AASRegistryAPIHelper.getRegistryPath());
            Collection descriptors = (Collection)result;
            return descriptors.stream().map(x -> new AASDescriptor((Map)x)).collect(Collectors.toList());
        }
        catch (Exception e) {
            if (e instanceof ProviderException) {
                throw (ProviderException)e;
            }
            throw new ProviderException(e);
        }
    }

    @Override
    public void register(IIdentifier aas, SubmodelDescriptor smDescriptor) throws ProviderException {
        try {
            this.provider.setValue(AASRegistryAPIHelper.getSubmodelAccessPath(aas, smDescriptor.getIdentifier()), smDescriptor);
        }
        catch (Exception e) {
            if (e instanceof ProviderException) {
                throw (ProviderException)e;
            }
            throw new ProviderException(e);
        }
    }

    @Override
    public void delete(IIdentifier aasId, IIdentifier smId) throws ProviderException {
        try {
            this.provider.deleteValue(AASRegistryAPIHelper.getSubmodelAccessPath(aasId, smId));
        }
        catch (Exception e) {
            if (e instanceof ProviderException) {
                throw (ProviderException)e;
            }
            throw new ProviderException(e);
        }
    }

    @Override
    public List<SubmodelDescriptor> lookupSubmodels(IIdentifier aasId) throws ProviderException {
        try {
            Object result = this.provider.getValue(AASRegistryAPIHelper.getSubmodelListOfAASPath(aasId));
            Collection descriptors = (Collection)result;
            return descriptors.stream().map(x -> new SubmodelDescriptor((Map)x)).collect(Collectors.toList());
        }
        catch (Exception e) {
            if (e instanceof ProviderException) {
                throw (ProviderException)e;
            }
            throw new ProviderException(e);
        }
    }

    @Override
    public SubmodelDescriptor lookupSubmodel(IIdentifier aasId, IIdentifier smId) throws ProviderException {
        try {
            Object result = this.provider.getValue(AASRegistryAPIHelper.getSubmodelAccessPath(aasId, smId));
            return new SubmodelDescriptor((Map)result);
        }
        catch (Exception e) {
            if (e instanceof ProviderException) {
                throw (ProviderException)e;
            }
            throw new ProviderException(e);
        }
    }
}

