/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.aas.registration.mqtt;

import org.eclipse.basyx.extensions.shared.mqtt.PayloadParserHelper;
import org.eclipse.basyx.vab.exception.provider.ProviderException;

public class MqttAASRegistryServicePayloadParser {
    private String payload;
    private String submodelId;
    private String shellId;

    public MqttAASRegistryServicePayloadParser(String payload) {
        this.payload = payload;
        if (this.payload.startsWith("(")) {
            this.shellId = this.getShellIdFromPayload();
            this.submodelId = this.getSubmodelIdFromPayload();
        } else {
            this.shellId = payload;
        }
    }

    public String extractShellId() {
        return this.shellId;
    }

    public String extractSubmodelId() {
        if (!this.payload.startsWith("(")) {
            throw new ProviderException("The payload '" + this.payload + "' does not contain a Submodel ID");
        }
        return this.submodelId;
    }

    private String getShellIdFromPayload() {
        return PayloadParserHelper.extractIds(this.payload)[0];
    }

    private String getSubmodelIdFromPayload() {
        return PayloadParserHelper.extractIds(this.payload)[1];
    }
}

