/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.submodel.aggregator.authorization.internal;

import java.util.Collection;
import java.util.function.Supplier;
import org.eclipse.basyx.aas.metamodel.api.IAssetAdministrationShell;
import org.eclipse.basyx.extensions.shared.authorization.internal.BaSyxObjectTargetInformation;
import org.eclipse.basyx.extensions.shared.authorization.internal.ElevatedCodeAuthentication;
import org.eclipse.basyx.extensions.shared.authorization.internal.IRbacRuleChecker;
import org.eclipse.basyx.extensions.shared.authorization.internal.IRoleAuthenticator;
import org.eclipse.basyx.extensions.shared.authorization.internal.IdHelper;
import org.eclipse.basyx.extensions.shared.authorization.internal.InhibitException;
import org.eclipse.basyx.extensions.shared.authorization.internal.SimpleRbacHelper;
import org.eclipse.basyx.extensions.submodel.aggregator.authorization.internal.ISubmodelAggregatorAuthorizer;
import org.eclipse.basyx.submodel.metamodel.api.ISubmodel;
import org.eclipse.basyx.submodel.metamodel.api.identifier.IIdentifier;
import org.eclipse.basyx.submodel.restapi.api.ISubmodelAPI;

public class SimpleRbacSubmodelAggregatorAuthorizer<SubjectInformationType>
implements ISubmodelAggregatorAuthorizer<SubjectInformationType> {
    protected IRbacRuleChecker rbacRuleChecker;
    protected IRoleAuthenticator<SubjectInformationType> roleAuthenticator;

    public SimpleRbacSubmodelAggregatorAuthorizer(IRbacRuleChecker rbacRuleChecker, IRoleAuthenticator<SubjectInformationType> roleAuthenticator) {
        this.rbacRuleChecker = rbacRuleChecker;
        this.roleAuthenticator = roleAuthenticator;
    }

    @Override
    public Collection<ISubmodel> authorizeGetSubmodelList(SubjectInformationType subjectInformation, IAssetAdministrationShell aas, Supplier<Collection<ISubmodel>> smListSupplier) throws InhibitException {
        return smListSupplier.get();
    }

    @Override
    public ISubmodel authorizeGetSubmodel(SubjectInformationType subjectInformation, IAssetAdministrationShell aas, IIdentifier smId, Supplier<ISubmodel> smSupplier) throws InhibitException {
        IIdentifier aasId = this.getAASId(aas);
        SimpleRbacHelper.checkRule(this.rbacRuleChecker, this.roleAuthenticator, subjectInformation, "urn:org.eclipse.basyx:scope:sm-aggregator:read", new BaSyxObjectTargetInformation(IdHelper.getIdentifierId(aasId), IdHelper.getIdentifierId(smId), null));
        return smSupplier.get();
    }

    @Override
    public ISubmodel authorizeGetSubmodelbyIdShort(SubjectInformationType subjectInformation, IAssetAdministrationShell aas, String smIdShortPath, Supplier<ISubmodel> smSupplier) throws InhibitException {
        IIdentifier aasId = this.getAASId(aas);
        IIdentifier smId = this.getSmIdUnsecured(smSupplier);
        SimpleRbacHelper.checkRule(this.rbacRuleChecker, this.roleAuthenticator, subjectInformation, "urn:org.eclipse.basyx:scope:sm-aggregator:read", new BaSyxObjectTargetInformation(IdHelper.getIdentifierId(aasId), IdHelper.getIdentifierId(smId), null));
        return smSupplier.get();
    }

    @Override
    public ISubmodelAPI authorizeGetSubmodelAPIById(SubjectInformationType subjectInformation, IAssetAdministrationShell aas, IIdentifier smId, Supplier<ISubmodelAPI> smAPISupplier) throws InhibitException {
        IIdentifier aasId = this.getAASId(aas);
        SimpleRbacHelper.checkRule(this.rbacRuleChecker, this.roleAuthenticator, subjectInformation, "urn:org.eclipse.basyx:scope:sm-aggregator:read", new BaSyxObjectTargetInformation(IdHelper.getIdentifierId(aasId), IdHelper.getIdentifierId(smId), null));
        return smAPISupplier.get();
    }

    @Override
    public ISubmodelAPI authorizeGetSubmodelAPIByIdShort(SubjectInformationType subjectInformation, IAssetAdministrationShell aas, String smIdShortPath, Supplier<ISubmodelAPI> smAPISupplier) throws InhibitException {
        IIdentifier aasId = this.getAASId(aas);
        IIdentifier smId = this.getSmIdUnsecuredByAPI(smAPISupplier);
        SimpleRbacHelper.checkRule(this.rbacRuleChecker, this.roleAuthenticator, subjectInformation, "urn:org.eclipse.basyx:scope:sm-aggregator:read", new BaSyxObjectTargetInformation(IdHelper.getIdentifierId(aasId), IdHelper.getIdentifierId(smId), null));
        return smAPISupplier.get();
    }

    @Override
    public void authorizeCreateSubmodel(SubjectInformationType subjectInformation, IAssetAdministrationShell aas, IIdentifier smId) throws InhibitException {
        IIdentifier aasId = this.getAASId(aas);
        SimpleRbacHelper.checkRule(this.rbacRuleChecker, this.roleAuthenticator, subjectInformation, "urn:org.eclipse.basyx:scope:sm-aggregator:write", new BaSyxObjectTargetInformation(IdHelper.getIdentifierId(aasId), IdHelper.getIdentifierId(smId), null));
    }

    @Override
    public void authorizeUpdateSubmodel(SubjectInformationType subjectInformation, IAssetAdministrationShell aas, IIdentifier smId) throws InhibitException {
        IIdentifier aasId = this.getAASId(aas);
        SimpleRbacHelper.checkRule(this.rbacRuleChecker, this.roleAuthenticator, subjectInformation, "urn:org.eclipse.basyx:scope:sm-aggregator:write", new BaSyxObjectTargetInformation(IdHelper.getIdentifierId(aasId), IdHelper.getIdentifierId(smId), null));
    }

    @Override
    public void authorizeDeleteSubmodelByIdentifier(SubjectInformationType subjectInformation, IAssetAdministrationShell aas, IIdentifier smId) throws InhibitException {
        IIdentifier aasId = this.getAASId(aas);
        SimpleRbacHelper.checkRule(this.rbacRuleChecker, this.roleAuthenticator, subjectInformation, "urn:org.eclipse.basyx:scope:sm-aggregator:write", new BaSyxObjectTargetInformation(IdHelper.getIdentifierId(aasId), IdHelper.getIdentifierId(smId), null));
    }

    private IIdentifier getAASId(IAssetAdministrationShell aas) {
        return aas != null ? aas.getIdentification() : null;
    }

    private IIdentifier getSmIdUnsecured(Supplier<ISubmodel> smSupplier) {
        try (ElevatedCodeAuthentication.ElevatedCodeAuthenticationAreaHandler ignored = ElevatedCodeAuthentication.enterElevatedCodeAuthenticationArea();){
            ISubmodel sm = smSupplier.get();
            if (sm == null) {
                IIdentifier iIdentifier = null;
                return iIdentifier;
            }
            IIdentifier iIdentifier = sm.getIdentification();
            return iIdentifier;
        }
    }

    private IIdentifier getSmIdUnsecuredByAPI(Supplier<ISubmodelAPI> smAPISupplier) {
        try (ElevatedCodeAuthentication.ElevatedCodeAuthenticationAreaHandler ignored = ElevatedCodeAuthentication.enterElevatedCodeAuthenticationArea();){
            ISubmodelAPI smAPI = smAPISupplier.get();
            if (smAPI == null) {
                IIdentifier iIdentifier = null;
                return iIdentifier;
            }
            ISubmodel sm = smAPI.getSubmodel();
            if (sm == null) {
                IIdentifier iIdentifier = null;
                return iIdentifier;
            }
            IIdentifier iIdentifier = sm.getIdentification();
            return iIdentifier;
        }
    }
}

