/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.extensions.submodel.mqtt;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.basyx.extensions.shared.mqtt.MqttEventService;
import org.eclipse.basyx.extensions.submodel.mqtt.MqttV2SubmodelAPITopicFactory;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.ISubmodelElement;
import org.eclipse.basyx.submodel.metamodel.facade.SubmodelElementMapCollectionConverter;
import org.eclipse.basyx.submodel.metamodel.facade.submodelelement.SubmodelElementFacadeFactory;
import org.eclipse.basyx.submodel.restapi.observing.ISubmodelAPIObserverV2;
import org.eclipse.basyx.vab.coder.json.serialization.DefaultTypeFactory;
import org.eclipse.basyx.vab.coder.json.serialization.GSONTools;
import org.eclipse.basyx.vab.coder.json.serialization.Serializer;
import org.eclipse.basyx.vab.modelprovider.VABPathTools;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;

public class MqttV2SubmodelAPIObserver
extends MqttEventService
implements ISubmodelAPIObserverV2 {
    protected boolean useWhitelist = false;
    protected Set<String> whitelist = new HashSet<String>();
    private MqttV2SubmodelAPITopicFactory payloadFactory;
    private Serializer payloadSerializer;

    public MqttV2SubmodelAPIObserver(MqttClient client, MqttV2SubmodelAPITopicFactory topicFactory) throws MqttException {
        this(client, topicFactory, MqttV2SubmodelAPIObserver.createGSONTools());
    }

    public MqttV2SubmodelAPIObserver(MqttClient client, MqttV2SubmodelAPITopicFactory topicFactory, Serializer payloadSerializer) throws MqttException {
        super(client);
        this.payloadFactory = topicFactory;
        this.payloadSerializer = payloadSerializer;
        this.connectMqttClientIfRequired();
    }

    private static GSONTools createGSONTools() {
        return new GSONTools(new DefaultTypeFactory(), false, false);
    }

    private void connectMqttClientIfRequired() throws MqttException {
        if (!this.mqttClient.isConnected()) {
            this.mqttClient.connect();
        }
    }

    public void observeSubmodelElement(String shortId) {
        this.whitelist.add(VABPathTools.stripSlashes(shortId));
    }

    public void setWhitelist(Set<String> shortIds) {
        this.whitelist.clear();
        for (String entry : shortIds) {
            this.whitelist.add(VABPathTools.stripSlashes(entry));
        }
    }

    public void disableWhitelist() {
        this.useWhitelist = false;
    }

    public void enableWhitelist() {
        this.useWhitelist = true;
    }

    @Override
    public void elementAdded(String idShortPath, Object newValue, String aasId, String submodelId, String repoId) {
        if (newValue instanceof Map && this.filter(idShortPath)) {
            ISubmodelElement submodelElement = this.setValueNull(newValue);
            this.sendMqttMessage(this.payloadFactory.createCreateSubmodelElementTopic(aasId, submodelId, idShortPath, repoId), this.serializePayload(submodelElement));
        }
    }

    @Override
    public void elementDeleted(String idShortPath, ISubmodelElement submodelElement, String aasId, String submodelId, String repoId) {
        if (submodelElement instanceof Map && this.filter(idShortPath)) {
            ISubmodelElement sme = this.setValueNull(submodelElement);
            this.sendMqttMessage(this.payloadFactory.createDeleteSubmodelElementTopic(aasId, submodelId, idShortPath, repoId), this.serializePayload(sme));
        }
    }

    @Override
    public void elementUpdated(String idShortPath, ISubmodelElement submodelElement, String aasId, String submodelId, String repoId) {
        if (submodelElement instanceof Map && this.filter(idShortPath)) {
            ISubmodelElement sme = this.setValueNull(submodelElement);
            this.sendMqttMessage(this.payloadFactory.createUpdateSubmodelElementTopic(aasId, submodelId, idShortPath, repoId), this.serializePayload(sme));
        }
    }

    @Override
    public void elementValue(String idShortPath, Object value, String aasId, String submodelId, String repoId) {
        if (this.filter(idShortPath)) {
            this.sendMqttMessage(this.payloadFactory.createSubmodelElementValueTopic(aasId, submodelId, idShortPath, repoId), this.serializePayload(value));
        }
    }

    private boolean filter(String idShort) {
        idShort = VABPathTools.stripSlashes(idShort);
        return !this.useWhitelist || this.whitelist.contains(idShort);
    }

    private ISubmodelElement setValueNull(Object submodelElement) {
        Map<String, Object> map = SubmodelElementMapCollectionConverter.smElementToMap((Map)submodelElement);
        LinkedHashMap<String, Object> copy = new LinkedHashMap<String, Object>(map);
        ISubmodelElement newSubmodelElement = SubmodelElementFacadeFactory.createSubmodelElement(copy);
        newSubmodelElement.setValue(null);
        return newSubmodelElement;
    }

    private String serializePayload(Object payload) {
        if (payload == null) {
            return null;
        }
        return this.payloadSerializer.serialize(payload);
    }
}

