/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.factory.xml.converters.submodelelement.relationship;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.basyx.submodel.factory.xml.XMLHelper;
import org.eclipse.basyx.submodel.factory.xml.converters.submodelelement.SubmodelElementCollectionXMLConverter;
import org.eclipse.basyx.submodel.factory.xml.converters.submodelelement.relationship.RelationshipElementXMLConverter;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.dataelement.IDataElement;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.relationship.IAnnotatedRelationshipElement;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElement;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.relationship.AnnotatedRelationshipElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AnnotatedRelationshipElementXMLConverter {
    public static final String ANNOTATED_RELATIONSHIP_ELEMENT = "aas:annotatedRelationshipElement";
    public static final String ANNOTATIONS = "aas:annotations";

    public static AnnotatedRelationshipElement parseAnnotatedRelationshipElement(Map<String, Object> xmlObject) {
        AnnotatedRelationshipElement annotatedElement = new AnnotatedRelationshipElement();
        RelationshipElementXMLConverter.populateRelationshipElement(xmlObject, annotatedElement);
        Map xmlAnnotations = (Map)xmlObject.get(ANNOTATIONS);
        List<Map<String, Object>> xmlDataElements = XMLHelper.getList(xmlAnnotations.get("aas:dataElement"));
        ArrayList<IDataElement> dataElements = new ArrayList<IDataElement>();
        for (Map<String, Object> element : xmlDataElements) {
            SubmodelElement smElement = SubmodelElementCollectionXMLConverter.getSubmodelElement(element);
            if (smElement instanceof IDataElement) {
                dataElements.add((IDataElement)((Object)smElement));
                continue;
            }
            throw new RuntimeException("AnnotatedRelationshipElement '" + annotatedElement.getIdShort() + "' can only contain IDataElement as annotation");
        }
        annotatedElement.setAnnotation(dataElements);
        return annotatedElement;
    }

    public static Element buildAnnotatedRelationshipElement(Document document, IAnnotatedRelationshipElement annotatedElement) {
        Element root = document.createElement(ANNOTATED_RELATIONSHIP_ELEMENT);
        RelationshipElementXMLConverter.populateRelationshipElement(document, root, annotatedElement);
        Element annotationsRoot = document.createElement(ANNOTATIONS);
        root.appendChild(annotationsRoot);
        for (IDataElement dataElement : annotatedElement.getValue().getAnnotations()) {
            Element dataElementRoot = document.createElement("aas:dataElement");
            Element dataElementContent = SubmodelElementCollectionXMLConverter.buildSubmodelElement(document, dataElement);
            dataElementRoot.appendChild(dataElementContent);
            annotationsRoot.appendChild(dataElementRoot);
        }
        return root;
    }
}

