/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.submodel.metamodel.map.submodelelement.event;

import java.util.Map;
import org.eclipse.basyx.aas.metamodel.exception.MetamodelConstructionException;
import org.eclipse.basyx.submodel.metamodel.api.reference.IReference;
import org.eclipse.basyx.submodel.metamodel.api.reference.enums.KeyElements;
import org.eclipse.basyx.submodel.metamodel.api.submodelelement.event.IBasicEvent;
import org.eclipse.basyx.submodel.metamodel.map.modeltype.ModelType;
import org.eclipse.basyx.submodel.metamodel.map.reference.Reference;
import org.eclipse.basyx.submodel.metamodel.map.submodelelement.SubmodelElement;

public class BasicEvent
extends SubmodelElement
implements IBasicEvent {
    public static final String MODELTYPE = "BasicEvent";
    public static final String OBSERVED = "observed";

    public BasicEvent() {
        this.putAll(new ModelType(MODELTYPE));
    }

    public BasicEvent(IReference observed) {
        this();
        this.put(OBSERVED, observed);
    }

    public BasicEvent(String idShort, IReference observed) {
        super(idShort);
        this.putAll(new ModelType(MODELTYPE));
        this.put(OBSERVED, observed);
    }

    @Override
    protected KeyElements getKeyElement() {
        return KeyElements.BASICEVENT;
    }

    public static BasicEvent createAsFacade(Map<String, Object> obj) {
        if (obj == null) {
            return null;
        }
        if (!BasicEvent.isValid(obj)) {
            throw new MetamodelConstructionException(BasicEvent.class, obj);
        }
        BasicEvent facade = new BasicEvent();
        facade.setMap(obj);
        return facade;
    }

    public static boolean isValid(Map<String, Object> obj) {
        return SubmodelElement.isValid(obj) && obj.containsKey(OBSERVED);
    }

    public static boolean isBasicEvent(Map<String, Object> map) {
        String modelType = ModelType.createAsFacade(map).getName();
        return MODELTYPE.equals(modelType) || modelType == null && map.containsKey(OBSERVED);
    }

    @Override
    public IReference getObserved() {
        return Reference.createAsFacade((Map)this.get(OBSERVED));
    }

    @Override
    public IReference getValue() {
        return this.getObserved();
    }

    @Override
    public void setValue(Object value) {
        if (!Reference.isReference(value)) {
            throw new IllegalArgumentException("Given Object is not a Reference");
        }
        this.put(OBSERVED, Reference.createAsFacade((Map)value));
    }

    @Override
    public BasicEvent getLocalCopy() {
        BasicEvent copy = new BasicEvent();
        copy.putAll(this);
        return copy;
    }
}

