/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.vab.protocol.http.server;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.valves.HealthCheckValve;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.FilterMap;
import org.eclipse.basyx.vab.protocol.http.server.BaSyxContext;
import org.eclipse.basyx.vab.protocol.http.server.BasysHTTPServlet;
import org.eclipse.basyx.vab.protocol.http.server.JwtBearerTokenAuthenticationConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.oauth2.core.DelegatingOAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jose.jws.SignatureAlgorithm;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtClaimValidator;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtValidators;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationProvider;
import org.springframework.security.oauth2.server.resource.web.BearerTokenAuthenticationEntryPoint;
import org.springframework.security.oauth2.server.resource.web.BearerTokenAuthenticationFilter;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.ExceptionTranslationFilter;
import org.springframework.security.web.firewall.HttpFirewall;
import org.springframework.security.web.firewall.StrictHttpFirewall;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;

public class BaSyxHTTPServer {
    private static final Logger logger = LoggerFactory.getLogger(BaSyxHTTPServer.class);
    private final Tomcat tomcat = new Tomcat();

    public BaSyxHTTPServer(BaSyxContext context) {
        this.tomcat.getEngine().setName(UUID.randomUUID().toString());
        if (context.isSecuredConnectionEnabled()) {
            Connector httpsConnector = this.tomcat.getConnector();
            this.configureSslConnector(context, httpsConnector);
        } else {
            this.tomcat.setPort(context.port);
        }
        this.tomcat.setHostname(context.hostname);
        this.tomcat.getHost().setAppBase(".");
        this.configureHealthEndpoint();
        File docBase = new File(context.docBasePath);
        Context rootCtx = this.tomcat.addContext(context.contextPath, docBase.getAbsolutePath());
        context.getJwtBearerTokenAuthenticationConfiguration().ifPresent(jwtBearerTokenAuthenticationConfiguration -> this.addSecurityFiltersToContext(rootCtx, (JwtBearerTokenAuthenticationConfiguration)jwtBearerTokenAuthenticationConfiguration));
        Iterator servletIterator = context.entrySet().iterator();
        while (servletIterator.hasNext()) {
            this.addNewServletAndMappingToTomcatEnvironment(context, rootCtx, servletIterator.next());
        }
    }

    private void configureHealthEndpoint() {
        HealthCheckValve valve = new HealthCheckValve();
        this.tomcat.getHost().getPipeline().addValve((Valve)valve);
    }

    private void addNewServletAndMappingToTomcatEnvironment(BaSyxContext context, Context rootCtx, Map.Entry<String, HttpServlet> entry) {
        String mapping = entry.getKey();
        HttpServlet servlet = entry.getValue();
        this.configureCorsOrigin(context, servlet);
        Tomcat.addServlet((Context)rootCtx, (String)Integer.toString(servlet.hashCode()), (Servlet)servlet);
        rootCtx.addServletMappingDecoded(mapping, Integer.toString(servlet.hashCode()));
    }

    private void configureCorsOrigin(BaSyxContext context, HttpServlet servlet) {
        if (!this.isCorsOriginDefined(context)) {
            return;
        }
        try {
            ((BasysHTTPServlet)servlet).setCorsOrigin(context.getAccessControlAllowOrigin());
        }
        catch (RuntimeException e) {
            logger.info("DefaultServlet cannot be cast to BasysHTTPServlet " + e);
        }
    }

    private boolean isCorsOriginDefined(BaSyxContext context) {
        return context.getAccessControlAllowOrigin() != null;
    }

    private void addSecurityFiltersToContext(Context context, JwtBearerTokenAuthenticationConfiguration jwtBearerTokenAuthenticationConfiguration) {
        FilterChainProxy filterChainProxy = this.createFilterChainProxy(jwtBearerTokenAuthenticationConfiguration);
        this.addFilterChainProxyFilterToContext(context, filterChainProxy);
    }

    private void addFilterChainProxyFilterToContext(Context context, FilterChainProxy filterChainProxy) {
        FilterDef filterChainProxyFilterDefinition = this.createFilterChainProxyFilterDefinition(filterChainProxy);
        context.addFilterDef(filterChainProxyFilterDefinition);
        FilterMap filterChainProxyFilterMapping = this.createFilterChainProxyFilterMap();
        context.addFilterMap(filterChainProxyFilterMapping);
    }

    private FilterMap createFilterChainProxyFilterMap() {
        FilterMap filterChainProxyFilterMapping = new FilterMap();
        filterChainProxyFilterMapping.setFilterName(FilterChainProxy.class.getSimpleName());
        filterChainProxyFilterMapping.addURLPattern("/*");
        return filterChainProxyFilterMapping;
    }

    private FilterDef createFilterChainProxyFilterDefinition(FilterChainProxy filterChainProxy) {
        FilterDef filterChainProxyFilterDefinition = new FilterDef();
        filterChainProxyFilterDefinition.setFilterName(FilterChainProxy.class.getSimpleName());
        filterChainProxyFilterDefinition.setFilterClass(FilterChainProxy.class.getName());
        filterChainProxyFilterDefinition.setFilter((Filter)filterChainProxy);
        return filterChainProxyFilterDefinition;
    }

    private FilterChainProxy createFilterChainProxy(JwtBearerTokenAuthenticationConfiguration jwtBearerTokenAuthenticationConfiguration) {
        FilterChainProxy filterChainProxy = new FilterChainProxy(this.createSecurityFilterChain(jwtBearerTokenAuthenticationConfiguration));
        filterChainProxy.setFirewall(this.createHttpFirewall());
        return filterChainProxy;
    }

    private HttpFirewall createHttpFirewall() {
        StrictHttpFirewall httpFirewall = new StrictHttpFirewall();
        httpFirewall.setAllowUrlEncodedSlash(true);
        return httpFirewall;
    }

    private SecurityFilterChain createSecurityFilterChain(JwtBearerTokenAuthenticationConfiguration jwtBearerTokenAuthenticationConfiguration) {
        ArrayList<Object> sortedListOfFilters = new ArrayList<Object>();
        sortedListOfFilters.add(this.createBearerTokenAuthenticationFilter(jwtBearerTokenAuthenticationConfiguration));
        sortedListOfFilters.add(this.createExceptionTranslationFilter());
        return new DefaultSecurityFilterChain(AnyRequestMatcher.INSTANCE, sortedListOfFilters);
    }

    private ExceptionTranslationFilter createExceptionTranslationFilter() {
        BearerTokenAuthenticationEntryPoint authenticationEntryPoint = new BearerTokenAuthenticationEntryPoint();
        return new ExceptionTranslationFilter((AuthenticationEntryPoint)authenticationEntryPoint);
    }

    private BearerTokenAuthenticationFilter createBearerTokenAuthenticationFilter(JwtBearerTokenAuthenticationConfiguration jwtBearerTokenAuthenticationConfiguration) {
        JwtDecoder jwtDecoder = this.createJwtDecoder(jwtBearerTokenAuthenticationConfiguration.getIssuerUri(), jwtBearerTokenAuthenticationConfiguration.getJwkSetUri(), jwtBearerTokenAuthenticationConfiguration.getRequiredAud().orElse(null));
        JwtAuthenticationProvider jwtAuthenticationProvider = new JwtAuthenticationProvider(jwtDecoder);
        ProviderManager authenticationManager = new ProviderManager(new AuthenticationProvider[]{jwtAuthenticationProvider});
        return new BearerTokenAuthenticationFilter((AuthenticationManager)authenticationManager);
    }

    private JwtDecoder createJwtDecoder(String issuerUri, String jwkSetUri, @Nullable String requiredAud) {
        NimbusJwtDecoder nimbusJwtDecoder = NimbusJwtDecoder.withJwkSetUri((String)jwkSetUri).jwsAlgorithm(SignatureAlgorithm.from((String)"RS256")).build();
        nimbusJwtDecoder.setJwtValidator(this.createOAuth2TokenValidator(issuerUri, requiredAud));
        return nimbusJwtDecoder;
    }

    private OAuth2TokenValidator<Jwt> createOAuth2TokenValidator(String issuerUri, @Nullable String requiredAud) {
        ArrayList<Object> validators = new ArrayList<Object>();
        validators.add(JwtValidators.createDefaultWithIssuer((String)issuerUri));
        if (requiredAud != null) {
            validators.add(this.createJwtClaimValidatorForRequiredAudience(requiredAud));
        }
        return new DelegatingOAuth2TokenValidator(validators);
    }

    private JwtClaimValidator<Collection<String>> createJwtClaimValidatorForRequiredAudience(String requiredAud) {
        return new JwtClaimValidator("aud", aud -> null != aud && aud.contains(requiredAud));
    }

    private void configureSslConnector(BaSyxContext context, Connector httpsConnector) {
        httpsConnector.setPort(context.port);
        httpsConnector.setSecure(true);
        httpsConnector.setScheme("https");
        httpsConnector.setAttribute("keystoreFile", (Object)context.getCertificatePath());
        httpsConnector.setAttribute("clientAuth", (Object)"false");
        httpsConnector.setAttribute("sslProtocol", (Object)"TLS");
        httpsConnector.setAttribute("SSLEnabled", (Object)true);
        httpsConnector.setAttribute("protocol", (Object)"HTTP/1.1");
        httpsConnector.setAttribute("keystorePass", (Object)context.getKeyPassword());
        httpsConnector.setAttribute("keyAlias", (Object)"tomcat");
        httpsConnector.setAttribute("maxThreads", (Object)"200");
        httpsConnector.setAttribute("protocol", (Object)"org.apache.coyote.http11.Http11AprProtocol");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        logger.trace("Starting Tomcat.....");
        Thread serverThread = new Thread(() -> {
            try {
                this.stopTomcatServerIfRunningAlready();
                this.tomcat.getServer().addLifecycleListener(new LifecycleListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void lifecycleEvent(LifecycleEvent event) {
                        if (event.getLifecycle().getState() == LifecycleState.STARTED) {
                            Tomcat tomcat = BaSyxHTTPServer.this.tomcat;
                            synchronized (tomcat) {
                                BaSyxHTTPServer.this.tomcat.notifyAll();
                            }
                        }
                    }
                });
                this.tomcat.getConnector();
                this.tomcat.start();
                this.tomcat.getServer().await();
            }
            catch (LifecycleException e) {
                logger.error("Failed to start HTTP server.", (Throwable)e);
                Tomcat tomcat = this.tomcat;
                synchronized (tomcat) {
                    this.tomcat.notifyAll();
                }
            }
        });
        serverThread.start();
        EnumSet<LifecycleState> returnStates = EnumSet.of(LifecycleState.STARTED, LifecycleState.FAILED);
        Tomcat tomcat = this.tomcat;
        synchronized (tomcat) {
            try {
                while (!returnStates.contains(this.tomcat.getServer().getState())) {
                    this.tomcat.wait();
                }
            }
            catch (InterruptedException e) {
                logger.error("Interrupted while waiting for tomcat to start. Stopping tomcat.", (Throwable)e);
                this.shutdown();
            }
        }
    }

    private void stopTomcatServerIfRunningAlready() throws LifecycleException {
        if (!this.isTomcatServerRunning()) {
            return;
        }
        this.tomcat.stop();
    }

    private boolean isTomcatServerRunning() {
        return this.tomcat != null && this.tomcat.getServer().getState() == LifecycleState.STARTED;
    }

    public void shutdown() {
        logger.trace("Shutting down BaSyx HTTP Server...");
        try {
            this.tomcat.stop();
            this.tomcat.destroy();
        }
        catch (LifecycleException e) {
            logger.error("Exception in shutdown", (Throwable)e);
        }
    }

    public boolean hasEnded() {
        return this.tomcat.getServer().getState() != LifecycleState.STARTED;
    }

    static {
        System.setProperty("org.apache.tomcat.util.buf.UDecoder.ALLOW_ENCODED_SLASH", "true");
        if (System.getProperty("org.apache.catalina.startup.EXIT_ON_INIT_FAILURE") == null) {
            System.setProperty("org.apache.catalina.startup.EXIT_ON_INIT_FAILURE", "true");
        }
    }
}

