/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.vab.protocol.https;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import org.eclipse.basyx.vab.protocol.http.connector.HTTPConnector;
import org.eclipse.basyx.vab.protocol.http.connector.IAuthorizationSupplier;
import org.eclipse.basyx.vab.protocol.https.JerseyHttpsClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPSConnector
extends HTTPConnector {
    private static Logger logger = LoggerFactory.getLogger(HTTPSConnector.class);

    public HTTPSConnector(String address) {
        super(address);
        this.setHttpsClientWithValidation();
    }

    public HTTPSConnector(String address, String mediaType) {
        super(address, mediaType);
        this.setHttpsClientWithValidation();
    }

    public HTTPSConnector(String address, IAuthorizationSupplier authorizationSupplier) {
        super(address, authorizationSupplier);
        this.setHttpsClientWithValidation();
    }

    public HTTPSConnector(String address, IAuthorizationSupplier authorizationSupplier, boolean validateFlag) {
        super(address, authorizationSupplier);
        if (validateFlag) {
            this.setHttpsClientWithValidation();
        } else {
            this.setHttpsClientWithoutValidation();
        }
    }

    private void setHttpsClientWithoutValidation() {
        try {
            this.client = JerseyHttpsClientFactory.getJerseyHTTPSClientWithoutValidation();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            logger.error("Cannot create a https client");
        }
    }

    private void setHttpsClientWithValidation() {
        try {
            this.client = JerseyHttpsClientFactory.getJerseyHTTPSClientWithValidation();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            logger.error("Cannot create a https client");
        }
    }
}

