/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.controller.v7_0.category;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.management.plugin.controller.CategoryController;
import org.apache.qpid.server.management.plugin.controller.CategoryControllerFactory;
import org.apache.qpid.server.management.plugin.controller.LegacyManagementController;
import org.apache.qpid.server.management.plugin.controller.v7_0.category.LegacyCategoryController;
import org.apache.qpid.server.plugin.PluggableService;

@PluggableService
public class LegacyCategoryControllerFactory
implements CategoryControllerFactory {
    public static final String CATEGORY_BROKER = "Broker";
    private static final String CATEGORY_BROKER_LOGGER = "BrokerLogger";
    private static final String CATEGORY_BROKER_LOG_INCLUSION_RULE = "BrokerLogInclusionRule";
    public static final String CATEGORY_AUTHENTICATION_PROVIDER = "AuthenticationProvider";
    private static final String CATEGORY_USER = "User";
    private static final String CATEGORY_ACCESS_CONTROL_PROVIDER = "AccessControlProvider";
    private static final String CATEGORY_PLUGIN = "Plugin";
    private static final String CATEGORY_TRUST_STORE = "TrustStore";
    private static final String CATEGORY_KEY_STORE = "KeyStore";
    public static final String CATEGORY_PORT = "Port";
    private static final String CATEGORY_VIRTUAL_HOST_ALIAS = "VirtualHostAlias";
    private static final String CATEGORY_GROUP_PROVIDER = "GroupProvider";
    private static final String CATEGORY_GROUP = "Group";
    private static final String CATEGORY_GROUP_MEMBER = "GroupMember";
    private static final String CATEGORY_VIRTUAL_HOST_NODE = "VirtualHostNode";
    private static final String CATEGORY_REMOTE_REPLICATION_NODE = "RemoteReplicationNode";
    public static final String CATEGORY_VIRTUAL_HOST = "VirtualHost";
    private static final String CATEGORY_VIRTUAL_HOST_LOGGER = "VirtualHostLogger";
    private static final String CATEGORY_VIRTUAL_HOST_LOG_INCLUSION_RULE = "VirtualHostLogInclusionRule";
    private static final String CATEGORY_VIRTUAL_HOST_ACCESS_CONTROL_PROVIDER = "VirtualHostAccessControlProvider";
    private static final String CATEGORY_EXCHANGE = "Exchange";
    private static final String CATEGORY_QUEUE = "Queue";
    private static final String CATEGORY_CONSUMER = "Consumer";
    private static final String CATEGORY_CONNECTION = "Connection";
    private static final String CATEGORY_SESSION = "Session";
    static final String CATEGORY_SYSTEM_CONFIG = "SystemConfig";
    public static final Map<String, String> SUPPORTED_CATEGORIES = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put(LegacyCategoryControllerFactory.CATEGORY_BROKER_LOGGER, LegacyCategoryControllerFactory.CATEGORY_BROKER);
            this.put(LegacyCategoryControllerFactory.CATEGORY_BROKER_LOG_INCLUSION_RULE, LegacyCategoryControllerFactory.CATEGORY_BROKER_LOGGER);
            this.put(LegacyCategoryControllerFactory.CATEGORY_AUTHENTICATION_PROVIDER, LegacyCategoryControllerFactory.CATEGORY_BROKER);
            this.put(LegacyCategoryControllerFactory.CATEGORY_USER, LegacyCategoryControllerFactory.CATEGORY_AUTHENTICATION_PROVIDER);
            this.put(LegacyCategoryControllerFactory.CATEGORY_ACCESS_CONTROL_PROVIDER, LegacyCategoryControllerFactory.CATEGORY_BROKER);
            this.put(LegacyCategoryControllerFactory.CATEGORY_PLUGIN, LegacyCategoryControllerFactory.CATEGORY_BROKER);
            this.put(LegacyCategoryControllerFactory.CATEGORY_TRUST_STORE, LegacyCategoryControllerFactory.CATEGORY_BROKER);
            this.put(LegacyCategoryControllerFactory.CATEGORY_KEY_STORE, LegacyCategoryControllerFactory.CATEGORY_BROKER);
            this.put(LegacyCategoryControllerFactory.CATEGORY_PORT, LegacyCategoryControllerFactory.CATEGORY_BROKER);
            this.put(LegacyCategoryControllerFactory.CATEGORY_VIRTUAL_HOST_ALIAS, LegacyCategoryControllerFactory.CATEGORY_PORT);
            this.put(LegacyCategoryControllerFactory.CATEGORY_GROUP_PROVIDER, LegacyCategoryControllerFactory.CATEGORY_BROKER);
            this.put(LegacyCategoryControllerFactory.CATEGORY_GROUP, LegacyCategoryControllerFactory.CATEGORY_GROUP_PROVIDER);
            this.put(LegacyCategoryControllerFactory.CATEGORY_GROUP_MEMBER, LegacyCategoryControllerFactory.CATEGORY_GROUP);
            this.put(LegacyCategoryControllerFactory.CATEGORY_VIRTUAL_HOST_NODE, LegacyCategoryControllerFactory.CATEGORY_BROKER);
            this.put(LegacyCategoryControllerFactory.CATEGORY_REMOTE_REPLICATION_NODE, LegacyCategoryControllerFactory.CATEGORY_VIRTUAL_HOST_NODE);
            this.put(LegacyCategoryControllerFactory.CATEGORY_VIRTUAL_HOST, LegacyCategoryControllerFactory.CATEGORY_VIRTUAL_HOST_NODE);
            this.put(LegacyCategoryControllerFactory.CATEGORY_VIRTUAL_HOST_LOGGER, LegacyCategoryControllerFactory.CATEGORY_VIRTUAL_HOST);
            this.put(LegacyCategoryControllerFactory.CATEGORY_VIRTUAL_HOST_LOG_INCLUSION_RULE, LegacyCategoryControllerFactory.CATEGORY_VIRTUAL_HOST_LOGGER);
            this.put(LegacyCategoryControllerFactory.CATEGORY_VIRTUAL_HOST_ACCESS_CONTROL_PROVIDER, LegacyCategoryControllerFactory.CATEGORY_VIRTUAL_HOST);
            this.put(LegacyCategoryControllerFactory.CATEGORY_EXCHANGE, LegacyCategoryControllerFactory.CATEGORY_VIRTUAL_HOST);
            this.put(LegacyCategoryControllerFactory.CATEGORY_QUEUE, LegacyCategoryControllerFactory.CATEGORY_VIRTUAL_HOST);
            this.put(LegacyCategoryControllerFactory.CATEGORY_CONSUMER, LegacyCategoryControllerFactory.CATEGORY_QUEUE);
            this.put(LegacyCategoryControllerFactory.CATEGORY_CONNECTION, LegacyCategoryControllerFactory.CATEGORY_VIRTUAL_HOST);
            this.put(LegacyCategoryControllerFactory.CATEGORY_SESSION, LegacyCategoryControllerFactory.CATEGORY_CONNECTION);
            this.put(LegacyCategoryControllerFactory.CATEGORY_BROKER, LegacyCategoryControllerFactory.CATEGORY_SYSTEM_CONFIG);
        }
    });
    public static final Map<String, String> DEFAULT_TYPES = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put(LegacyCategoryControllerFactory.CATEGORY_BROKER_LOGGER, LegacyCategoryControllerFactory.CATEGORY_BROKER);
            this.put(LegacyCategoryControllerFactory.CATEGORY_TRUST_STORE, "FileTrustStore");
            this.put(LegacyCategoryControllerFactory.CATEGORY_KEY_STORE, "FileKeyStore");
            this.put(LegacyCategoryControllerFactory.CATEGORY_GROUP, "ManagedGroup");
            this.put(LegacyCategoryControllerFactory.CATEGORY_GROUP_MEMBER, "ManagedGroupMember");
            this.put(LegacyCategoryControllerFactory.CATEGORY_VIRTUAL_HOST, "ProvidedStore");
            this.put(LegacyCategoryControllerFactory.CATEGORY_QUEUE, "standard");
        }
    });

    @Override
    public CategoryController createController(String type, LegacyManagementController legacyManagementController) {
        if (SUPPORTED_CATEGORIES.containsKey(type)) {
            return new LegacyCategoryController(legacyManagementController, type, SUPPORTED_CATEGORIES.get(type), DEFAULT_TYPES.get(type), legacyManagementController.getTypeControllersByCategory(type));
        }
        throw new IllegalArgumentException(String.format("Unsupported type '%s'", type));
    }

    @Override
    public Set<String> getSupportedCategories() {
        return SUPPORTED_CATEGORIES.keySet();
    }

    @Override
    public String getModelVersion() {
        return "7.0";
    }

    public String getType() {
        return LegacyCategoryControllerFactory.class.getName();
    }
}

