/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.filter;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.qpid.server.management.plugin.HttpManagementConfiguration;
import org.apache.qpid.server.management.plugin.HttpManagementUtil;

public class MethodFilter
implements Filter {
    private static final Set<String> REST_API_METHODS = new HashSet<String>(Arrays.asList("GET", "POST", "PUT", "DELETE"));
    private HttpManagementConfiguration<?> _managementConfiguration;

    public void init(FilterConfig filterConfig) throws ServletException {
        this._managementConfiguration = HttpManagementUtil.getManagementConfiguration(filterConfig.getServletContext());
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String method = String.valueOf(httpRequest.getMethod()).toUpperCase();
        if (REST_API_METHODS.contains(method) || this.isCorsAllowedMethod(method)) {
            chain.doFilter(request, response);
        } else {
            httpResponse.sendError(403);
        }
    }

    private boolean isCorsAllowedMethod(String method) {
        return this._managementConfiguration.getCorsAllowMethods().stream().anyMatch(m -> m.equalsIgnoreCase(method));
    }
}

