/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.services.environment;

import de.iip_ecosphere.platform.services.environment.AbstractDelegatingService;
import de.iip_ecosphere.platform.services.environment.DataIngestor;
import de.iip_ecosphere.platform.services.environment.GenericMultiTypeService;
import de.iip_ecosphere.platform.services.environment.GenericMultiTypeServiceImpl;
import de.iip_ecosphere.platform.services.environment.Service;
import de.iip_ecosphere.platform.services.environment.YamlService;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslator;
import java.io.IOException;
import java.util.concurrent.ExecutionException;

public abstract class AbstractDelegatingMultiService<S extends Service>
extends AbstractDelegatingService<S>
implements GenericMultiTypeService {
    private GenericMultiTypeServiceImpl impl = new GenericMultiTypeServiceImpl();

    public AbstractDelegatingMultiService(YamlService yaml) {
        super(yaml);
    }

    protected <O> void handleResult(Class<O> cls, String data, String typeName) {
        try {
            GenericMultiTypeServiceImpl.OutTypeInfo<?> info = this.impl.getOutTypeInfo(typeName);
            if (null != info) {
                TypeTranslator<String, ?> outT = info.getOutTranslator();
                if (outT != null) {
                    Object tmp = outT.to((Object)data);
                    DataIngestor<?> ingestor = info.validateAndGetIngestor(typeName);
                    ingestor.ingest(tmp);
                } else {
                    AbstractDelegatingMultiService.getLogger().error("No result type translator registered for: {}", (Object)typeName);
                }
            }
        }
        catch (IOException e) {
            AbstractDelegatingMultiService.getLogger().error("Receiving result: {}", (Object)e.getMessage());
        }
    }

    @Override
    public <I> void registerInputTypeTranslator(Class<I> inCls, String inTypeName, TypeTranslator<I, String> inTrans) {
        this.impl.registerInputTypeTranslator(inCls, inTypeName, inTrans);
    }

    @Override
    public <O> void registerOutputTypeTranslator(Class<O> outCls, String outTypeName, TypeTranslator<String, O> outTrans) {
        this.impl.registerOutputTypeTranslator(outCls, outTypeName, outTrans);
    }

    @Override
    public <O> void attachIngestor(Class<O> outCls, String outTypeName, DataIngestor<O> ingestor) {
        this.impl.attachIngestor(outCls, outTypeName, ingestor);
    }

    @Override
    public void registerInOutRelation(String inTypeName, String outTypeName) {
        this.impl.registerInOutRelation(inTypeName, outTypeName);
    }

    @Override
    public String getOutTypeName(String inTypeName) {
        return this.impl.getOutTypeName(inTypeName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <I> void process(String inType, I data) throws ExecutionException {
        GenericMultiTypeServiceImpl.InTypeInfo<?> info = this.impl.getInTypeInfo(inType);
        if (null == info) throw new ExecutionException("No input type translator registered", null);
        TypeTranslator<?, String> inT = info.getInTranslator();
        if (null == inT) throw new ExecutionException("No input type translator registered", null);
        try {
            this.processImpl(inType, (String)inT.to(data));
            return;
        }
        catch (IOException e) {
            throw new ExecutionException("Cannot transfer data to service: " + e.getMessage(), e);
        }
    }

    protected abstract void processImpl(String var1, String var2) throws IOException;

    @Override
    public <I, O> O processSync(String inTypeName, I data, String outTypeName) throws ExecutionException {
        this.process(inTypeName, data);
        GenericMultiTypeServiceImpl.OutTypeInfo<?> outInfo = this.impl.getOutTypeInfo(outTypeName);
        DataIngestor<?> ingestor = outInfo.validateAndGetIngestor(outTypeName);
        return (O)ingestor.waitForResult();
    }

    protected static Logger getLogger() {
        return LoggerFactory.getLogger(AbstractDelegatingMultiService.class);
    }

    protected GenericMultiTypeServiceImpl getImpl() {
        return this.impl;
    }
}

