/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.io;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.exodus.io.Block;
import jetbrains.exodus.io.DataReader;
import jetbrains.exodus.io.RemoveBlockType;
import jetbrains.exodus.io.SharedMappedFilesCache;
import jetbrains.exodus.io.SharedOpenFilesCache;
import jetbrains.exodus.log.Log;
import jetbrains.exodus.log.LogUtil;
import jetbrains.exodus.util.SharedRandomAccessFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDataReader
implements DataReader {
    private static final Logger logger = LoggerFactory.getLogger(FileDataReader.class);
    private static final String DELETED_FILE_EXTENSION = ".del";
    @NotNull
    private final File dir;
    private final boolean useNio;
    @Nullable
    private Log log;

    public FileDataReader(@NotNull File dir, int openFiles) {
        this(dir, openFiles, true, EnvironmentConfig.DEFAULT.getLogCacheFreePhysicalMemoryThreshold());
    }

    public FileDataReader(@NotNull File dir, int openFiles, boolean useNio, long freePhysicalMemoryThreshold) {
        this.dir = dir;
        this.useNio = useNio;
        SharedOpenFilesCache.setSize(openFiles);
        if (useNio) {
            SharedMappedFilesCache.createInstance(freePhysicalMemoryThreshold);
        }
    }

    @Override
    public Block[] getBlocks() {
        File[] files = LogUtil.listFiles(this.dir);
        Block[] result = new Block[files.length];
        for (int i = 0; i < files.length; ++i) {
            result[i] = this.getBlock(LogUtil.getAddress(files[i].getName()));
        }
        FileDataReader.sortBlocks(result);
        return result;
    }

    @Override
    public void removeBlock(long blockAddress, @NotNull RemoveBlockType rbt) {
        boolean deleted;
        File file = new File(this.dir, LogUtil.getLogFilename(blockAddress));
        this.removeFileFromFileCache(file);
        FileDataReader.setWritable(file);
        boolean bl = deleted = rbt == RemoveBlockType.Delete ? file.delete() : FileDataReader.renameFile(file);
        if (!deleted) {
            throw new ExodusException("Failed to delete " + file.getAbsolutePath());
        }
        if (logger.isInfoEnabled()) {
            logger.info("Deleted file " + file.getAbsolutePath());
        }
    }

    @Override
    public void truncateBlock(long blockAddress, long length) {
        FileBlock file = this.getBlock(blockAddress);
        this.removeFileFromFileCache(file);
        FileDataReader.setWritable(file);
        try {
            try (SharedRandomAccessFile f = new SharedRandomAccessFile((File)file, "rw");){
                f.setLength(length);
            }
            if (logger.isInfoEnabled()) {
                logger.info("Truncated file " + file.getAbsolutePath() + " to length = " + length);
            }
        }
        catch (IOException e) {
            throw new ExodusException("Failed to truncate file " + file.getAbsolutePath(), (Throwable)e);
        }
    }

    @Override
    public void clear() {
        this.close();
        for (File file : LogUtil.listFiles(this.dir)) {
            if (!file.canWrite()) {
                FileDataReader.setWritable(file);
            }
            if (!file.exists() || file.delete()) continue;
            throw new ExodusException("Failed to delete " + file);
        }
    }

    @Override
    public void close() {
        try {
            SharedOpenFilesCache.getInstance().removeDirectory(this.dir);
            if (this.useNio) {
                SharedMappedFilesCache.getInstance().removeDirectory(this.dir);
            }
        }
        catch (IOException e) {
            throw new ExodusException("Can't close all files", (Throwable)e);
        }
    }

    @Override
    public void setLog(@NotNull Log log) {
        this.log = log;
    }

    @Override
    public String getLocation() {
        return this.dir.getPath();
    }

    @Override
    public FileBlock getBlock(long address) {
        return new FileBlock(address);
    }

    public static void sortBlocks(Block[] result) {
        Arrays.sort(result, new Comparator<Block>(){

            @Override
            public int compare(Block o1, Block o2) {
                if (o1.getAddress() < o2.getAddress()) {
                    return -1;
                }
                if (o1.getAddress() > o2.getAddress()) {
                    return 1;
                }
                return 0;
            }
        });
    }

    private void removeFileFromFileCache(@NotNull File file) {
        try {
            SharedOpenFilesCache.getInstance().removeFile(file);
            if (this.useNio) {
                SharedMappedFilesCache.getInstance().removeFileBuffer(file);
            }
        }
        catch (IOException e) {
            throw new ExodusException((Throwable)e);
        }
    }

    private static boolean renameFile(@NotNull File file) {
        String name = file.getName();
        return file.renameTo(new File(file.getParent(), name.substring(0, name.indexOf(".xd")) + DELETED_FILE_EXTENSION));
    }

    private static void setWritable(@NotNull File file) {
        if (file.exists() && !file.setWritable(true)) {
            throw new ExodusException("Failed to set writable " + file.getAbsolutePath());
        }
    }

    static /* synthetic */ boolean access$200(FileDataReader x0) {
        return x0.useNio;
    }

    static /* synthetic */ Log access$300(FileDataReader x0) {
        return x0.log;
    }

    static /* synthetic */ Logger access$400() {
        return logger;
    }

    private final class FileBlock
    extends File
    implements Block {
        private final long address;

        private FileBlock(long address) {
            super(FileDataReader.this.dir, LogUtil.getLogFilename(address));
            this.address = address;
        }

        @Override
        public long getAddress() {
            return this.address;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(byte[] output, long position, int count) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK], 0[TRYBLOCK], 17[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

