/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.log;

import java.io.File;
import java.io.FilenameFilter;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.core.dataStructures.hash.IntHashMap;
import jetbrains.exodus.util.IOUtil;
import org.jetbrains.annotations.NotNull;

public final class LogUtil {
    public static final int LOG_BLOCK_ALIGNMENT = 1024;
    public static final int LOG_FILE_NAME_LENGTH = 11;
    public static final int LOG_FILE_EXTENSION_LENGTH = 3;
    public static final int LOG_FILE_NAME_WITH_EXT_LENGTH = 14;
    public static final String LOG_FILE_EXTENSION = ".xd";
    private static final char[] LOG_FILE_EXTENSION_CHARS = ".xd".toCharArray();
    private static final FilenameFilter LOG_FILE_NAME_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.length() == 14 && name.endsWith(LogUtil.LOG_FILE_EXTENSION);
        }
    };
    private static final char[] LOG_FILE_NAME_ALPHABET = "0123456789abcdefghijklmnopqrstuv".toCharArray();
    private static final IntHashMap<Integer> ALPHA_INDEXES = new IntHashMap();

    private LogUtil() {
    }

    public static String getLogFilename(long address) {
        if (address < 0L) {
            throw new ExodusException("Starting address of a log file is negative: " + address);
        }
        if (address % 1024L != 0L) {
            throw new ExodusException("Starting address of a log file is badly aligned: " + address);
        }
        address /= 1024L;
        char[] name = new char[14];
        for (int i = 1; i <= 11; ++i) {
            name[11 - i] = LOG_FILE_NAME_ALPHABET[(int)(address & 0x1FL)];
            address >>= 5;
        }
        System.arraycopy(LOG_FILE_EXTENSION_CHARS, 0, name, 11, 3);
        return new String(name);
    }

    public static long getAddress(String logFilename) {
        int length = logFilename.length();
        if (length != 14 || !logFilename.endsWith(LOG_FILE_EXTENSION)) {
            throw new ExodusException("Invalid log file name: " + logFilename);
        }
        long address = 0L;
        for (int i = 0; i < 11; ++i) {
            char c = logFilename.charAt(i);
            Integer integer = (Integer)ALPHA_INDEXES.get((int)c);
            if (integer == null) {
                throw new ExodusException("Invalid log file name: " + logFilename);
            }
            address = (address << 5) + (long)integer.intValue();
        }
        return address * 1024L;
    }

    public static boolean isLogFile(@NotNull File file) {
        return LogUtil.isLogFileName(file.getName());
    }

    public static boolean isLogFileName(@NotNull String name) {
        try {
            LogUtil.getAddress(name);
            return true;
        }
        catch (ExodusException e) {
            return false;
        }
    }

    @NotNull
    public static File[] listFiles(@NotNull File directory) {
        return IOUtil.listFiles((File)directory, (FilenameFilter)LOG_FILE_NAME_FILTER);
    }

    public static String getWrongAddressErrorMessage(long address, long fileSize) {
        long fileAddress = address - address % (fileSize * 1024L);
        return ", address = " + address + ", file = " + LogUtil.getLogFilename(fileAddress);
    }

    static {
        char[] alphabet = LOG_FILE_NAME_ALPHABET;
        for (int i = 0; i < alphabet.length; ++i) {
            ALPHA_INDEXES.put((int)alphabet[i], (Object)i);
        }
    }
}

