/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.metrics;

import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Function;

public class LinuxSystemMetricsUtils {
    public static final String THERMAL_FOLDER = "/sys/class/thermal";
    private static String thermalFolder = "/sys/class/thermal";

    public static String setThermalFolder(String folder) {
        String old = thermalFolder;
        if (null != folder && folder.length() > 0) {
            thermalFolder = folder;
        }
        return old;
    }

    public static File getSysTempFile(File file, String typePrefix) {
        File thermal;
        File result = file;
        if (null == result && (thermal = new File(thermalFolder)).exists()) {
            for (File f : thermal.listFiles()) {
                if (!f.isDirectory()) continue;
                File typeFile = new File(f, "type");
                try {
                    String type = FileUtils.readFileToString((File)typeFile);
                    if (!type.startsWith(typePrefix)) continue;
                    result = new File(f, "temp");
                    break;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    public static float getSysTemp(File file) {
        float result = -274.0f;
        if (null != file) {
            try {
                String tmp = FileUtils.readFileToString((File)file).trim();
                result = (float)((double)Integer.parseInt(tmp) / 1000.0);
            }
            catch (IOException | NumberFormatException exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static String readStdoutFromProgram(String dflt, String ... call) {
        String result = dflt;
        try {
            Process p = new ProcessBuilder(call).start();
            result = IOUtils.toString((InputStream)p.getInputStream());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static int readIntStdoutFromProgram(int dflt, String ... call) {
        return LinuxSystemMetricsUtils.readIntStdoutFromProgram(dflt, null, call);
    }

    public static int readIntStdoutFromProgram(int dflt, Function<String, String> pre, String ... call) {
        int result;
        String tmp = LinuxSystemMetricsUtils.readStdoutFromProgram(String.valueOf(dflt), call);
        if (null != pre) {
            tmp = pre.apply(tmp);
        }
        try {
            result = Integer.parseInt(tmp);
        }
        catch (NumberFormatException e) {
            result = dflt;
        }
        return result;
    }
}

