/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.ecsRuntime.kubernetes;

import de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy.AasK8SJavaProxy;
import de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy.K8SJavaProxy;
import de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy.K8SRequest;
import de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy.MasterAasCreator;
import de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy.ProxyType;
import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.AasServer;
import de.iip_ecosphere.platform.support.aas.BasicSetupSpec;
import de.iip_ecosphere.platform.support.aas.DeploymentRecipe;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.Registry;
import de.iip_ecosphere.platform.support.aas.ServerRecipe;
import de.iip_ecosphere.platform.support.aas.SetupSpec;
import de.iip_ecosphere.platform.support.net.KeyStoreDescriptor;
import java.io.File;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.Response;
import okio.Buffer;
import org.bouncycastle.util.Arrays;

public class MasterK8SAas {
    private static String serverIP;
    private static String serverPort;
    private static int aasPort;
    private static Map<String, Response> requestMapIDs;
    private static K8SJavaProxy aasK8SJavaProxy;
    private int vabPort;

    public MasterK8SAas(String serverIP, String serverPort, int vabPort, int aasPort, boolean tlsCheck) {
        MasterK8SAas.serverIP = serverIP;
        MasterK8SAas.serverPort = serverPort;
        this.vabPort = vabPort;
        MasterK8SAas.aasPort = aasPort;
        aasK8SJavaProxy = new AasK8SJavaProxy(ProxyType.MasterProxy, aasPort, serverIP, serverPort, tlsCheck);
    }

    public String getServerIP() {
        return serverIP;
    }

    public void setServerIP(String serverIP) {
        MasterK8SAas.serverIP = serverIP;
    }

    public String getServerPort() {
        return serverPort;
    }

    public void setServerPort(String serverPort) {
        MasterK8SAas.serverPort = serverPort;
    }

    public int getVabPort() {
        return this.vabPort;
    }

    public void setVabPort(int vabPort) {
        this.vabPort = vabPort;
    }

    public int getAasPort() {
        return aasPort;
    }

    public void setAasPort(int aasPort) {
        MasterK8SAas.aasPort = aasPort;
    }

    public ArrayList<Server> startLocalAas() throws IOException {
        ServerAddress vabServer = new ServerAddress(Schema.HTTP, serverIP, this.vabPort);
        ServerAddress aasServer = new ServerAddress(Schema.HTTP, serverIP, aasPort);
        Endpoint aasServerRegistry = new Endpoint(aasServer, "registry");
        BasicSetupSpec spec = new BasicSetupSpec(aasServerRegistry, aasServer);
        spec.setAssetServerAddress(vabServer, "");
        Aas aas = MasterAasCreator.createAas((ServerAddress)vabServer);
        ProtocolServerBuilder pBuilder = AasFactory.getInstance().createProtocolServerBuilder((SetupSpec)spec);
        pBuilder.defineProperty("name", () -> "K8SAasProperty", null);
        pBuilder.defineProperty("version", () -> "0.0.1", null);
        pBuilder.defineProperty("description", () -> "K8S AAS", null);
        pBuilder.defineOperation("sendToK8S", params -> MasterK8SAas.sendToK8S(params));
        pBuilder.defineOperation("sendWatchToK8S", params -> MasterK8SAas.sendWatchToK8S(params));
        Server server = (Server)pBuilder.build();
        server.start();
        AasServer httpServer = AasFactory.getInstance().createDeploymentRecipe((SetupSpec)spec).forRegistry().deploy(aas).createServer(new String[0]).start();
        ArrayList<Server> servers = new ArrayList<Server>();
        servers.add((Server)httpServer);
        servers.add(server);
        File file = new File("ServerReady.k8s");
        file.createNewFile();
        return servers;
    }

    public ArrayList<Server> startLocalTLSAas() throws IOException {
        File keyPath = new File("./src/test/resources/keystore.jks");
        KeyStoreDescriptor kstore = new KeyStoreDescriptor(keyPath, "a1234567", "tomcat");
        ServerAddress vabServer = new ServerAddress(Schema.HTTPS, serverIP, this.vabPort);
        ServerAddress aasServer = new ServerAddress(Schema.HTTP, serverIP, aasPort);
        ServerAddress aasServerS = new ServerAddress(Schema.HTTPS, serverIP, 1234);
        Endpoint regEp = new Endpoint(aasServer, "registry");
        BasicSetupSpec spec = new BasicSetupSpec(regEp, aasServer, kstore);
        spec.setAssetServerAddress(vabServer, "");
        Aas aas = MasterAasCreator.createAas((ServerAddress)vabServer);
        ProtocolServerBuilder pBuilder = AasFactory.getInstance().createProtocolServerBuilder((SetupSpec)spec);
        pBuilder.defineProperty("name", () -> "K8SAasProperty", null);
        pBuilder.defineProperty("version", () -> "0.0.1", null);
        pBuilder.defineProperty("description", () -> "K8S AAS", null);
        pBuilder.defineOperation("sendToK8S", params -> MasterK8SAas.sendToK8S(params));
        pBuilder.defineOperation("sendWatchToK8S", params -> MasterK8SAas.sendWatchToK8S(params));
        Server server = (Server)pBuilder.build();
        server.start();
        AasFactory factory = AasFactory.getInstance();
        ServerRecipe srcp = factory.createServerRecipe();
        Server regServer = srcp.createRegistryServer((SetupSpec)spec, (ServerRecipe.PersistenceType)ServerRecipe.LocalPersistenceType.INMEMORY, new String[0]).start();
        Endpoint serverEp = new Endpoint(aasServerS, "cloud");
        BasicSetupSpec specS = new BasicSetupSpec(regEp, (ServerAddress)serverEp, kstore);
        DeploymentRecipe.RegistryDeploymentRecipe regD = factory.createDeploymentRecipe((SetupSpec)specS).forRegistry(regEp);
        Registry reg = regD.obtainRegistry();
        AasServer cloudServer = regD.createServer(new String[0]).start();
        reg.createAas(aas, serverEp.toUri());
        reg.createSubmodel(aas, aas.getSubmodel("MasterK8SAasService"));
        ArrayList<Server> servers = new ArrayList<Server>();
        servers.add(server);
        servers.add(regServer);
        servers.add((Server)cloudServer);
        File file = new File("ServerReady.k8s");
        file.createNewFile();
        return servers;
    }

    private static Object sendToK8S(Object[] params) {
        String requestString = null;
        if (params.length > 0 && params[0] != null) {
            requestString = params[0].toString();
        }
        K8SRequest request = new K8SRequest();
        byte[] requestByte = request.convertBase64StringToByte(requestString);
        request = aasK8SJavaProxy.createK8SRequest(requestByte);
        byte[] response = null;
        try {
            response = aasK8SJavaProxy.executeK8SJavaClientRequest(null, request);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String responseBase64String = request.convertByteArrayToBase64String(response);
        return responseBase64String;
    }

    private static Object sendWatchToK8S(Object[] params) {
        String requestString = null;
        if (params.length > 0 && params[0] != null) {
            requestString = params[0].toString();
        }
        K8SRequest request = new K8SRequest();
        String[] requestArray = requestString.split("\\*");
        String requestID = request.convertBase64StringToString(requestArray[0]);
        byte[] requestByte = request.convertBase64StringToByte(requestArray[1]);
        Response response = null;
        byte[] responseBody = new byte[]{};
        try {
            if (requestMapIDs.containsKey(requestID)) {
                response = requestMapIDs.get(requestID);
                if (!response.body().source().exhausted()) {
                    String formattedHeaderResponse = request.getProtocol() + " " + response.code() + " " + response.message() + "\r\n" + response.headers().toString() + "\r\n";
                    if (formattedHeaderResponse.contains("application/vnd.kubernetes.protobuf")) {
                        Buffer buffer = new Buffer();
                        response.body().source().read(buffer, 4096L);
                        responseBody = buffer.readByteArray();
                    } else {
                        long count = response.body().source().indexOf((byte)10);
                        responseBody = response.body().source().readByteArray(count + 1L);
                    }
                    byte[] firstPart = (Integer.toHexString(responseBody.length) + "\r\n").getBytes();
                    responseBody = Arrays.concatenate((byte[])responseBody, (byte[])"\r\n".getBytes());
                    responseBody = Arrays.concatenate((byte[])firstPart, (byte[])responseBody);
                }
            } else {
                request = aasK8SJavaProxy.createK8SRequest(requestByte);
                response = aasK8SJavaProxy.executeWatchK8SJavaClientRequest(request);
                String formattedResponse = request.getProtocol() + " " + response.code() + " " + response.message() + "\r\n" + response.headers().toString() + "\r\n";
                responseBody = formattedResponse.getBytes();
                if (!response.body().source().exhausted()) {
                    if (formattedResponse.contains("application/vnd.kubernetes.protobuf")) {
                        Buffer buffer = new Buffer();
                        response.body().source().read(buffer, 4096L);
                        responseBody = buffer.readByteArray();
                    } else {
                        long count = response.body().source().indexOf((byte)10);
                        responseBody = response.body().source().readByteArray(count + 1L);
                    }
                    byte[] firstPart = (Integer.toHexString(responseBody.length) + "\r\n").getBytes();
                    responseBody = Arrays.concatenate((byte[])responseBody, (byte[])"\r\n".getBytes());
                    responseBody = Arrays.concatenate((byte[])firstPart, (byte[])responseBody);
                    responseBody = Arrays.concatenate((byte[])formattedResponse.getBytes(), (byte[])responseBody);
                }
                requestMapIDs.put(requestID, response);
            }
            if (responseBody == null || responseBody.length == 0) {
                responseBody = "0\r\n\r\n".getBytes();
                response.body().close();
                requestMapIDs.remove(requestID);
            }
        }
        catch (SocketTimeoutException e) {
            if (e.getMessage().contentEquals("timeout") || e.getMessage().contentEquals("Read timed out")) {
                responseBody = responseBody.length == 0 ? "0\r\n\r\n".getBytes() : Arrays.concatenate((byte[])responseBody, (byte[])"0\r\n\r\n".getBytes());
                requestMapIDs.remove(requestID);
                response.body().close();
            } else {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            responseBody = "0\r\n\r\n".getBytes();
            response.body().close();
            requestMapIDs.remove(requestID);
        }
        if (responseBody == null || responseBody.length == 0) {
            responseBody = "0\r\n\r\n".getBytes();
            System.out.println("Empty response AAS execute");
        }
        return request.convertByteArrayToBase64String(responseBody);
    }

    static {
        requestMapIDs = new ConcurrentHashMap<String, Response>();
    }
}

