/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.ecsRuntime.kubernetes;

import de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy.AbstractK8SJavaProxy;
import de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy.K8SRequest;
import de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy.ProxyType;
import de.iip_ecosphere.platform.ecsRuntime.kubernetes.proxy.TransportMessage;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.transport.TransportFactory;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import de.iip_ecosphere.platform.transport.connectors.TransportConnector;
import de.iip_ecosphere.platform.transport.connectors.TransportParameter;
import de.iip_ecosphere.platform.transport.serialization.SerializerRegistry;
import java.io.BufferedOutputStream;
import java.io.IOException;
import org.apache.http.client.ClientProtocolException;
import test.de.iip_ecosphere.platform.ecsRuntime.kubernetes.CallbackMessage;
import test.de.iip_ecosphere.platform.ecsRuntime.kubernetes.TransportK8STLS;
import test.de.iip_ecosphere.platform.ecsRuntime.kubernetes.TransportMessageJsonSerializer;

public class TransportK8SJavaProxy
extends AbstractK8SJavaProxy {
    private TransportConnector normalcl1;
    private TransportParameter param1;

    public TransportK8SJavaProxy(ProxyType proxyType, String serverIP, String serverPort, boolean tlsCheck) {
        super(proxyType, TransportK8SJavaProxy.getServerAddress((ProxyType)proxyType, (String)serverIP, (String)serverPort, (boolean)tlsCheck));
    }

    public TransportK8SJavaProxy(ProxyType proxyType, String serverIP, String serverPort, TransportK8STLS transportK8STLS) throws IOException {
        super(proxyType, TransportK8SJavaProxy.getServerAddress((ProxyType)proxyType, (String)serverIP, (String)serverPort, (boolean)transportK8STLS.isTlsCheck()));
        ServerAddress addr = new ServerAddress(Schema.HTTP, serverIP, Integer.parseInt(serverPort));
        TransportParameter.TransportParameterBuilder tpb1 = TransportParameter.TransportParameterBuilder.newBuilder((ServerAddress)addr).setApplicationId("cl1");
        if (transportK8STLS.isTlsCheck()) {
            transportK8STLS.getConfigurer().configure(tpb1);
        }
        this.param1 = tpb1.build();
        this.normalcl1 = TransportFactory.createConnector();
        this.normalcl1.connect(this.param1);
    }

    public TransportConnector getNormalcl1() {
        return this.normalcl1;
    }

    public void setNormalcl1(TransportConnector normalcl1) {
        this.normalcl1 = normalcl1;
    }

    public byte[] sendK8SRequest(BufferedOutputStream writer, K8SRequest request) throws IOException {
        byte[] response = null;
        response = this.getProxyType() == ProxyType.MasterProxy ? this.executeK8SJavaClientRequest(writer, request) : this.executeK8SGet(writer, request);
        return response;
    }

    public byte[] executeK8SGet(BufferedOutputStream writer, K8SRequest request) throws ClientProtocolException, IOException {
        byte[] responseByte = null;
        TransportMessage message1 = new TransportMessage(request.getPathNoParameter(), request.getRequestByte(), request.getPath().contains("&watch=true") ? "Yes" : "No");
        message1.generateStreamIdNo();
        SerializerRegistry.registerSerializer(TransportMessageJsonSerializer.class);
        try {
            TransportConnector cl1 = this.normalcl1;
            String stream1 = message1.getRequestWatch().equals("Yes") ? cl1.composeStreamName("", "watchStream1") : cl1.composeStreamName("", "stream1");
            String stream2 = cl1.composeStreamName("", message1.getStreamId());
            CallbackMessage cb1 = new CallbackMessage();
            cl1.setReceptionCallback(stream2, (ReceptionCallback)cb1);
            cl1.syncSend(stream1, (Object)message1);
            int y = 0;
            while (cb1.dequeIsEmpty()) {
                if (++y % 30000 == 0) {
                    System.out.println(message1.getStreamId() + " Still Outter waiting Path>> " + request.getMethod() + request.getPath());
                    return null;
                }
                TimeUtils.sleep((int)1);
            }
            responseByte = cb1.getData().getMessageByte();
            String responseString = new String(responseByte);
            if (message1.getRequestWatch().equals("Yes")) {
                while (!responseString.contains("0\r\n\r\n")) {
                    writer.write(responseByte);
                    writer.flush();
                    int x = 0;
                    while (cb1.dequeIsEmpty()) {
                        if (++x % 10000 == 0) {
                            System.out.println(message1.getStreamId() + " Still Inner waiting Path>> " + request.getMethod() + request.getPath());
                            return "0\r\n\r\n".getBytes();
                        }
                        TimeUtils.sleep((int)1);
                    }
                    responseByte = cb1.getData().getMessageByte();
                    responseString = new String(responseByte);
                }
            }
            cl1.unsubscribe(stream2, false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SerializerRegistry.unregisterSerializer(TransportMessageJsonSerializer.class);
        return responseByte;
    }

    public byte[] executeK8SPost(K8SRequest request) throws ClientProtocolException, IOException {
        return null;
    }

    public byte[] executeK8SPut(K8SRequest request) throws ClientProtocolException, IOException {
        return null;
    }

    public byte[] executeK8SPatch(K8SRequest request) throws ClientProtocolException, IOException {
        return null;
    }

    public byte[] executeK8SDelete(K8SRequest request) throws ClientProtocolException, IOException {
        return null;
    }
}

