/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.basyx.components.registry.mqtt;

import org.eclipse.basyx.aas.registration.api.IAASRegistry;
import org.eclipse.basyx.aas.registration.observing.ObservableAASRegistryServiceV2;
import org.eclipse.basyx.components.configuration.BaSyxMqttConfiguration;
import org.eclipse.basyx.components.registry.configuration.BaSyxRegistryConfiguration;
import org.eclipse.basyx.components.registry.mqtt.MqttRegistryFactory;
import org.eclipse.basyx.extensions.aas.registration.mqtt.MqttV2AASRegistryServiceObserver;
import org.eclipse.basyx.extensions.aas.registration.mqtt.MqttV2AASRegistryTopicFactory;
import org.eclipse.basyx.extensions.shared.encoding.IEncoder;
import org.eclipse.basyx.submodel.observer.IObserver;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttSecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttV2RegistryFactory {
    private static Logger logger = LoggerFactory.getLogger(MqttV2RegistryFactory.class);

    public IAASRegistry create(IAASRegistry registry, BaSyxMqttConfiguration mqttConfig, BaSyxRegistryConfiguration registryConfig, IEncoder idEncoder) {
        return MqttV2RegistryFactory.wrapRegistryInMqttObserver(registry, mqttConfig, registryConfig, idEncoder);
    }

    private static IAASRegistry wrapRegistryInMqttObserver(IAASRegistry registry, BaSyxMqttConfiguration mqttConfig, BaSyxRegistryConfiguration registryConfig, IEncoder idEncoder) {
        ObservableAASRegistryServiceV2 observedAPI = new ObservableAASRegistryServiceV2(registry, registryConfig.getRegistryId());
        MqttV2RegistryFactory.addAASRegistryServiceObserver(observedAPI, mqttConfig, idEncoder);
        return observedAPI;
    }

    protected static void addAASRegistryServiceObserver(ObservableAASRegistryServiceV2 observedAPI, BaSyxMqttConfiguration mqttConfig, IEncoder idEncoder) {
        try {
            MqttClient mqttClient = MqttV2RegistryFactory.createAndConnectMqttClient(mqttConfig);
            MqttV2AASRegistryServiceObserver mqttObserver = new MqttV2AASRegistryServiceObserver(mqttClient, new MqttV2AASRegistryTopicFactory(idEncoder));
            observedAPI.addObserver((IObserver)mqttObserver);
        }
        catch (MqttException e) {
            logger.error("Could not establish MQTT connection for MqttAASRegistry", (Throwable)e);
        }
    }

    private static MqttClient createAndConnectMqttClient(BaSyxMqttConfiguration mqttConfig) throws MqttException, MqttSecurityException {
        MqttClientPersistence mqttPersistence = MqttRegistryFactory.getMqttPersistenceFromConfig(mqttConfig);
        MqttClient mqttClient = new MqttClient(mqttConfig.getServer(), mqttConfig.getClientId(), mqttPersistence);
        MqttConnectOptions options = new MqttConnectOptions();
        options.setUserName(mqttConfig.getUser());
        options.setPassword(mqttConfig.getPass().toCharArray());
        mqttClient.connect(options);
        return mqttClient;
    }
}

