/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.bootstrap.netty;

import com.google.common.base.Preconditions;
import com.hivemq.bootstrap.netty.ChannelDependencies;
import com.hivemq.bootstrap.netty.ChannelInitializerFactory;
import com.hivemq.bootstrap.netty.initializer.AbstractChannelInitializer;
import com.hivemq.bootstrap.netty.initializer.TcpChannelInitializer;
import com.hivemq.bootstrap.netty.initializer.TlsTcpChannelInitializer;
import com.hivemq.bootstrap.netty.initializer.TlsWebsocketChannelInitializer;
import com.hivemq.bootstrap.netty.initializer.WebsocketChannelInitializer;
import com.hivemq.configuration.service.entity.Listener;
import com.hivemq.configuration.service.entity.TcpListener;
import com.hivemq.configuration.service.entity.TlsTcpListener;
import com.hivemq.configuration.service.entity.TlsWebsocketListener;
import com.hivemq.configuration.service.entity.WebsocketListener;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.logging.EventLog;
import com.hivemq.security.ssl.NonSslHandler;
import com.hivemq.security.ssl.SslFactory;
import javax.inject.Inject;
import javax.inject.Provider;

public class ChannelInitializerFactoryImpl
implements ChannelInitializerFactory {
    @NotNull
    private final ChannelDependencies channelDependencies;
    @NotNull
    private final SslFactory sslFactory;
    @NotNull
    private final Provider<NonSslHandler> nonSslHandlerProvider;
    @NotNull
    private final EventLog eventLog;

    @Inject
    public ChannelInitializerFactoryImpl(@NotNull ChannelDependencies channelDependencies, @NotNull SslFactory sslFactory, @NotNull Provider<NonSslHandler> nonSslHandlerProvider, @NotNull EventLog eventLog) {
        this.channelDependencies = channelDependencies;
        this.sslFactory = sslFactory;
        this.nonSslHandlerProvider = nonSslHandlerProvider;
        this.eventLog = eventLog;
    }

    @Override
    @NotNull
    public AbstractChannelInitializer getChannelInitializer(@NotNull Listener listener) {
        Preconditions.checkNotNull((Object)listener, (Object)"Listener must not be null");
        if (listener instanceof TcpListener) {
            if (listener instanceof TlsTcpListener) {
                return this.createTlsTcpInitializer((TlsTcpListener)listener);
            }
            return this.createTcpInitializer((TcpListener)listener);
        }
        if (listener instanceof WebsocketListener) {
            if (listener instanceof TlsWebsocketListener) {
                return this.createTlsWebsocketInitializer((TlsWebsocketListener)listener);
            }
            return this.createWebsocketInitializer((WebsocketListener)listener);
        }
        throw new IllegalArgumentException("Unknown listener type");
    }

    @NotNull
    protected AbstractChannelInitializer createTcpInitializer(@NotNull TcpListener listener) {
        return new TcpChannelInitializer(this.channelDependencies, listener, this.nonSslHandlerProvider);
    }

    @NotNull
    protected AbstractChannelInitializer createTlsTcpInitializer(@NotNull TlsTcpListener listener) {
        this.sslFactory.verifySslAtBootstrap(listener, listener.getTls());
        return new TlsTcpChannelInitializer(this.channelDependencies, listener, this.sslFactory);
    }

    @NotNull
    protected AbstractChannelInitializer createWebsocketInitializer(@NotNull WebsocketListener listener) {
        return new WebsocketChannelInitializer(this.channelDependencies, listener, this.nonSslHandlerProvider);
    }

    @NotNull
    protected AbstractChannelInitializer createTlsWebsocketInitializer(@NotNull TlsWebsocketListener listener) {
        this.sslFactory.verifySslAtBootstrap(listener, listener.getTls());
        return new TlsWebsocketChannelInitializer(this.channelDependencies, listener, this.sslFactory);
    }
}

