/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.decoder;

import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.codec.decoder.MqttDecoder;
import com.hivemq.codec.decoder.MqttPingreqDecoder;
import com.hivemq.codec.decoder.mqtt3.Mqtt3DisconnectDecoder;
import com.hivemq.codec.decoder.mqtt3.Mqtt3PubackDecoder;
import com.hivemq.codec.decoder.mqtt3.Mqtt3PubcompDecoder;
import com.hivemq.codec.decoder.mqtt3.Mqtt3PublishDecoder;
import com.hivemq.codec.decoder.mqtt3.Mqtt3PubrecDecoder;
import com.hivemq.codec.decoder.mqtt3.Mqtt3PubrelDecoder;
import com.hivemq.codec.decoder.mqtt3.Mqtt3SubscribeDecoder;
import com.hivemq.codec.decoder.mqtt3.Mqtt3UnsubscribeDecoder;
import com.hivemq.codec.decoder.mqtt5.Mqtt5AuthDecoder;
import com.hivemq.codec.decoder.mqtt5.Mqtt5DisconnectDecoder;
import com.hivemq.codec.decoder.mqtt5.Mqtt5PubackDecoder;
import com.hivemq.codec.decoder.mqtt5.Mqtt5PubcompDecoder;
import com.hivemq.codec.decoder.mqtt5.Mqtt5PublishDecoder;
import com.hivemq.codec.decoder.mqtt5.Mqtt5PubrecDecoder;
import com.hivemq.codec.decoder.mqtt5.Mqtt5PubrelDecoder;
import com.hivemq.codec.decoder.mqtt5.Mqtt5SubscribeDecoder;
import com.hivemq.codec.decoder.mqtt5.Mqtt5UnsubscribeDecoder;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.message.MessageType;
import com.hivemq.mqtt.message.ProtocolVersion;
import javax.inject.Inject;

@LazySingleton
public class MqttDecoders {
    private final @Nullable MqttDecoder @NotNull [] mqtt3Decoder = new MqttDecoder[16];
    private final @Nullable MqttDecoder @NotNull [] mqtt5Decoder = new MqttDecoder[16];

    @Inject
    public MqttDecoders(@NotNull Mqtt3PublishDecoder mqtt3PublishDecoder, @NotNull Mqtt3PubackDecoder mqtt3PubackDecoder, @NotNull Mqtt3PubrecDecoder mqtt3PubrecDecoder, @NotNull Mqtt3PubcompDecoder mqtt3PubcompDecoder, @NotNull Mqtt3PubrelDecoder mqtt3PubrelDecoder, @NotNull Mqtt3DisconnectDecoder mqtt3DisconnectDecoder, @NotNull Mqtt3SubscribeDecoder mqtt3SubscribeDecoder, @NotNull Mqtt3UnsubscribeDecoder mqtt3UnsubscribeDecoder, @NotNull MqttPingreqDecoder mqttPingreqDecoder, @NotNull Mqtt5PublishDecoder mqtt5PublishDecoder, @NotNull Mqtt5DisconnectDecoder mqtt5DisconnectDecoder, @NotNull Mqtt5SubscribeDecoder mqtt5SubscribeDecoder, @NotNull Mqtt5PubackDecoder mqtt5PubackDecoder, @NotNull Mqtt5PubrecDecoder mqtt5PubrecDecoder, @NotNull Mqtt5PubrelDecoder mqtt5PubrelDecoder, @NotNull Mqtt5PubcompDecoder mqtt5PubcompDecoder, @NotNull Mqtt5AuthDecoder mqtt5AuthDecoder, @NotNull Mqtt5UnsubscribeDecoder mqtt5UnsubscribeDecoder) {
        this.mqtt3Decoder[MessageType.PUBLISH.getType()] = mqtt3PublishDecoder;
        this.mqtt3Decoder[MessageType.PUBACK.getType()] = mqtt3PubackDecoder;
        this.mqtt3Decoder[MessageType.PUBREC.getType()] = mqtt3PubrecDecoder;
        this.mqtt3Decoder[MessageType.PUBREL.getType()] = mqtt3PubrelDecoder;
        this.mqtt3Decoder[MessageType.PUBCOMP.getType()] = mqtt3PubcompDecoder;
        this.mqtt3Decoder[MessageType.SUBSCRIBE.getType()] = mqtt3SubscribeDecoder;
        this.mqtt3Decoder[MessageType.UNSUBSCRIBE.getType()] = mqtt3UnsubscribeDecoder;
        this.mqtt3Decoder[MessageType.PINGREQ.getType()] = mqttPingreqDecoder;
        this.mqtt3Decoder[MessageType.DISCONNECT.getType()] = mqtt3DisconnectDecoder;
        this.mqtt5Decoder[MessageType.PUBLISH.getType()] = mqtt5PublishDecoder;
        this.mqtt5Decoder[MessageType.PUBACK.getType()] = mqtt5PubackDecoder;
        this.mqtt5Decoder[MessageType.PUBREC.getType()] = mqtt5PubrecDecoder;
        this.mqtt5Decoder[MessageType.PUBREL.getType()] = mqtt5PubrelDecoder;
        this.mqtt5Decoder[MessageType.PUBCOMP.getType()] = mqtt5PubcompDecoder;
        this.mqtt5Decoder[MessageType.SUBSCRIBE.getType()] = mqtt5SubscribeDecoder;
        this.mqtt5Decoder[MessageType.UNSUBSCRIBE.getType()] = mqtt5UnsubscribeDecoder;
        this.mqtt5Decoder[MessageType.PINGREQ.getType()] = mqttPingreqDecoder;
        this.mqtt5Decoder[MessageType.DISCONNECT.getType()] = mqtt5DisconnectDecoder;
        this.mqtt5Decoder[MessageType.AUTH.getType()] = mqtt5AuthDecoder;
    }

    @Nullable
    public MqttDecoder<?> decoder(@NotNull MessageType type, @NotNull ProtocolVersion version) {
        if (version == ProtocolVersion.MQTTv5) {
            return this.mqtt5Decoder[type.getType()];
        }
        return this.mqtt3Decoder[type.getType()];
    }
}

