/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.decoder.mqtt3;

import com.google.inject.Inject;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.codec.decoder.AbstractMqttDecoder;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import com.hivemq.mqtt.message.MessageType;
import com.hivemq.mqtt.message.ProtocolVersion;
import com.hivemq.mqtt.message.disconnect.DISCONNECT;
import io.netty.buffer.ByteBuf;

@LazySingleton
public class Mqtt3DisconnectDecoder
extends AbstractMqttDecoder<DISCONNECT> {
    private static final DISCONNECT DISCONNECT = new DISCONNECT();

    @Inject
    public Mqtt3DisconnectDecoder(@NotNull MqttServerDisconnector disconnector, @NotNull FullConfigurationService configurationService) {
        super(disconnector, configurationService);
    }

    @Override
    @Nullable
    public DISCONNECT decode(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, byte header) {
        if (clientConnectionContext.getProtocolVersion() == ProtocolVersion.MQTTv3_1_1 && !this.validateHeader(header)) {
            this.disconnectByInvalidFixedHeader(clientConnectionContext, MessageType.DISCONNECT);
            return null;
        }
        return DISCONNECT;
    }
}

