/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.decoder.mqtt5;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.codec.decoder.AbstractMqttConnectDecoder;
import com.hivemq.codec.encoder.mqtt5.Mqtt5PayloadFormatIndicator;
import com.hivemq.codec.encoder.mqtt5.MqttBinaryData;
import com.hivemq.codec.encoder.mqtt5.MqttVariableByteInteger;
import com.hivemq.configuration.HivemqId;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.handler.connack.MqttConnacker;
import com.hivemq.mqtt.message.QoS;
import com.hivemq.mqtt.message.connect.CONNECT;
import com.hivemq.mqtt.message.connect.MqttWillPublish;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.mqtt5.MqttUserProperty;
import com.hivemq.mqtt.message.reason.Mqtt5ConnAckReasonCode;
import com.hivemq.util.Bytes;
import com.hivemq.util.ClientIds;
import com.hivemq.util.Strings;
import com.hivemq.util.Topics;
import io.netty.buffer.ByteBuf;

@LazySingleton
public class Mqtt5ConnectDecoder
extends AbstractMqttConnectDecoder {
    private static final String PROTOCOL_NAME = "MQTT";
    @NotNull
    private final HivemqId hiveMQId;
    private static final long SESSION_EXPIRY_NOT_SET = Long.MAX_VALUE;
    private static final int RECEIVE_MAXIMUM_NOT_SET = Integer.MAX_VALUE;
    private static final int TOPIC_ALIAS_MAXIMUM_NOT_SET = Integer.MAX_VALUE;
    private static final long MAXIMUM_PACKET_SIZE_NOT_SET = Long.MAX_VALUE;

    public Mqtt5ConnectDecoder(@NotNull MqttConnacker mqttConnacker, @NotNull HivemqId hiveMQId, @NotNull ClientIds clientIds, @NotNull FullConfigurationService configurationService) {
        super(mqttConnacker, configurationService, clientIds);
        this.hiveMQId = hiveMQId;
    }

    @Override
    @Nullable
    public CONNECT decode(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, byte header) {
        Preconditions.checkNotNull((Object)clientConnectionContext, (Object)"A ClientContext must never be null");
        Preconditions.checkNotNull((Object)buf, (Object)"A byte buffer must never be null");
        if (!this.validateHeader(header)) {
            this.disconnectByInvalidFixedHeader(clientConnectionContext);
            return null;
        }
        ByteBuf fixedVariableHeader = this.decodeFixedVariableHeaderConnect(clientConnectionContext, buf);
        if (fixedVariableHeader == null) {
            return null;
        }
        if (!this.validateProtocolName(fixedVariableHeader, clientConnectionContext, PROTOCOL_NAME)) {
            return null;
        }
        fixedVariableHeader.skipBytes(1);
        byte connectFlagsByte = fixedVariableHeader.readByte();
        if (!this.validateConnectFlagByte(connectFlagsByte, clientConnectionContext)) {
            return null;
        }
        return this.decodeConnect(clientConnectionContext, buf, connectFlagsByte, fixedVariableHeader);
    }

    @Nullable
    private CONNECT decodeConnect(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, byte connectFlagsByte, @NotNull ByteBuf fixedVariableHeader) {
        MqttWillPublish mqttWillPublish;
        boolean cleanStart = Bytes.isBitSet(connectFlagsByte, 1);
        boolean will = Bytes.isBitSet(connectFlagsByte, 2);
        int willQos = (connectFlagsByte & 0x18) >> 3;
        boolean willRetain = Bytes.isBitSet(connectFlagsByte, 5);
        boolean passwordRequired = Bytes.isBitSet(connectFlagsByte, 6);
        boolean usernameRequired = Bytes.isBitSet(connectFlagsByte, 7);
        if (!this.validateWill(will, willRetain, willQos, clientConnectionContext)) {
            return null;
        }
        int keepAlive = fixedVariableHeader.readUnsignedShort();
        CONNECT.Mqtt5Builder connectBuilder = new CONNECT.Mqtt5Builder();
        if (!this.readConnectProperties(clientConnectionContext, buf, connectBuilder)) {
            return null;
        }
        String clientId = MqttBinaryData.decodeString(buf, this.validateUTF8);
        if (clientId == null) {
            this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "The client id of the client (IP: {}) is not well formed. This is not allowed.", "Sent CONNECT with malformed client id", Mqtt5ConnAckReasonCode.MALFORMED_PACKET, "Sent CONNECT with invalid client identifier.");
            return null;
        }
        if (clientId.isEmpty() && this.allowAssignedClientId) {
            clientId = this.clientIds.generateNext();
            clientConnectionContext.setClientIdAssigned(true);
        } else {
            if (clientId.isEmpty()) {
                this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "The client id of the client (IP: {}) is empty. This is not allowed.", "Sent CONNECT with empty client id", Mqtt5ConnAckReasonCode.CLIENT_IDENTIFIER_NOT_VALID, "Sent CONNECT with empty client identifier.");
                return null;
            }
            clientConnectionContext.setClientIdAssigned(false);
        }
        clientConnectionContext.setClientId(clientId);
        if (will) {
            mqttWillPublish = this.decodeAndValidateWill(clientConnectionContext, buf, willQos, willRetain);
            if (mqttWillPublish == null) {
                return null;
            }
        } else {
            mqttWillPublish = null;
        }
        if (!this.decodeAndValidateUsername(clientConnectionContext, buf, connectBuilder, usernameRequired)) {
            return null;
        }
        if (!this.decodeAndValidatePassword(clientConnectionContext, buf, connectBuilder, passwordRequired)) {
            return null;
        }
        clientConnectionContext.setCleanStart(cleanStart);
        return connectBuilder.withClientIdentifier(clientId).withCleanStart(cleanStart).withKeepAlive(keepAlive).withWillPublish(mqttWillPublish).build();
    }

    @Nullable
    private ImmutableList.Builder<MqttUserProperty> readUserProperty(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable ImmutableList.Builder<MqttUserProperty> userPropertiesBuilder) {
        MqttUserProperty userProperty = MqttUserProperty.decode(buf, this.validateUTF8);
        if (userProperty == null) {
            this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "A client (IP: {}) sent a CONNECT with a malformed user property. This is not allowed.", "Sent a CONNECT with a malformed user property", Mqtt5ConnAckReasonCode.MALFORMED_PACKET, "Sent CONNECT with malformed user property.");
            return null;
        }
        if (userPropertiesBuilder == null) {
            userPropertiesBuilder = ImmutableList.builder();
        }
        userPropertiesBuilder.add((Object)userProperty);
        return userPropertiesBuilder;
    }

    private boolean decodeAndValidateUsername(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, @NotNull CONNECT.Mqtt5Builder connectBuilder, boolean usernameRequired) {
        if (usernameRequired) {
            String username = MqttBinaryData.decodeString(buf, this.validateUTF8);
            if (username == null) {
                this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "A client (IP: {}) sent a CONNECT with a malformed UTF-8 string for username. This is not allowed.", "Sent a CONNECT with a malformed UTF-8 string for username", Mqtt5ConnAckReasonCode.MALFORMED_PACKET, "Sent CONNECT with malformed username.");
                return false;
            }
            clientConnectionContext.setAuthUsername(username);
            connectBuilder.withUsername(username);
        }
        return true;
    }

    private boolean decodeAndValidatePassword(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, @NotNull CONNECT.Mqtt5Builder connectBuilder, boolean passwordRequired) {
        if (passwordRequired) {
            byte[] password = MqttBinaryData.decode(buf);
            if (password == null) {
                this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "A client (IP: {}) sent a CONNECT with malformed password. This is not allowed.", "Sent a CONNECT with malformed password", Mqtt5ConnAckReasonCode.MALFORMED_PACKET, "Sent CONNECT with malformed password.");
                return false;
            }
            clientConnectionContext.setAuthPassword(password);
            connectBuilder.withPassword(password);
        }
        return true;
    }

    private boolean readConnectProperties(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, @NotNull CONNECT.Mqtt5Builder connectBuilder) {
        int readPropertyLength;
        int propertiesLength = MqttVariableByteInteger.decode(buf);
        if (this.propertiesLengthInvalid(clientConnectionContext, buf, propertiesLength)) {
            return false;
        }
        long sessionExpiryInterval = Long.MAX_VALUE;
        int receiveMaximum = Integer.MAX_VALUE;
        long maximumPacketSize = Long.MAX_VALUE;
        int topicAliasMaximum = Integer.MAX_VALUE;
        Boolean requestResponseInformation = null;
        Boolean requestProblemInformation = null;
        ImmutableList.Builder<MqttUserProperty> userPropertiesBuilder = null;
        String authMethod = null;
        byte[] authData = null;
        int propertiesStartIndex = buf.readerIndex();
        block11: while ((readPropertyLength = buf.readerIndex() - propertiesStartIndex) < propertiesLength) {
            byte propertyIdentifier = buf.readByte();
            switch (propertyIdentifier) {
                case 17: {
                    if ((sessionExpiryInterval = this.decodeSessionExpiryInterval(clientConnectionContext, buf, sessionExpiryInterval)) != -1L) continue block11;
                    return false;
                }
                case 33: {
                    if ((receiveMaximum = this.readReceiveMaximum(clientConnectionContext, buf, receiveMaximum)) != -1) continue block11;
                    return false;
                }
                case 39: {
                    if ((maximumPacketSize = this.readMaximumPacketSize(clientConnectionContext, buf, maximumPacketSize)) != -1L) continue block11;
                    return false;
                }
                case 34: {
                    if ((topicAliasMaximum = this.readTopicAliasMaximum(clientConnectionContext, buf, topicAliasMaximum)) != -1) continue block11;
                    return false;
                }
                case 25: {
                    if ((requestResponseInformation = this.readBoolean(clientConnectionContext, buf, requestResponseInformation, "request response information")) != null) continue block11;
                    return false;
                }
                case 23: {
                    if ((requestProblemInformation = this.readBoolean(clientConnectionContext, buf, requestProblemInformation, "request problem information")) != null) continue block11;
                    return false;
                }
                case 38: {
                    if ((userPropertiesBuilder = this.readUserProperty(clientConnectionContext, buf, userPropertiesBuilder)) != null) continue block11;
                    return false;
                }
                case 21: {
                    if ((authMethod = this.readAuthMethod(clientConnectionContext, buf, authMethod)) != null) continue block11;
                    return false;
                }
                case 22: {
                    if ((authData = this.readAuthData(clientConnectionContext, buf, authData)) != null) continue block11;
                    return false;
                }
            }
            this.connackByInvalidPropertyIdentifier(clientConnectionContext, propertyIdentifier);
            return false;
        }
        if (readPropertyLength != propertiesLength) {
            this.connackByMalformedPropertyLength(clientConnectionContext);
            return false;
        }
        if (authMethod == null && authData != null) {
            this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "A client (IP: {}) sent a CONNECT with a auth data but without auth method. This is not allowed.", "Sent a CONNECT with a auth data but without auth method", Mqtt5ConnAckReasonCode.PROTOCOL_ERROR, "Sent CONNECT with auth data and no auth method. This is a protocol violation.");
            return false;
        }
        Mqtt5UserProperties userProperties = Mqtt5UserProperties.build(userPropertiesBuilder);
        if (this.invalidUserPropertiesLength(clientConnectionContext, userProperties)) {
            return false;
        }
        if (sessionExpiryInterval == Long.MAX_VALUE) {
            sessionExpiryInterval = 0L;
        }
        if (receiveMaximum == Integer.MAX_VALUE) {
            receiveMaximum = 65535;
        }
        if (maximumPacketSize == Long.MAX_VALUE) {
            maximumPacketSize = 0x10000004L;
        }
        if (topicAliasMaximum == Integer.MAX_VALUE) {
            topicAliasMaximum = 0;
        }
        clientConnectionContext.setClientSessionExpiryInterval(sessionExpiryInterval);
        connectBuilder.withAuthMethod(authMethod).withAuthData(authData).withSessionExpiryInterval(sessionExpiryInterval).withReceiveMaximum(receiveMaximum).withMaximumPacketSize(maximumPacketSize).withTopicAliasMaximum(topicAliasMaximum).withResponseInformationRequested(requestResponseInformation == null ? false : requestResponseInformation).withProblemInformationRequested(requestProblemInformation == null ? true : requestProblemInformation).withUserProperties(userProperties);
        return true;
    }

    private int readReceiveMaximum(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, int receiveMaximum) {
        if (receiveMaximum != Integer.MAX_VALUE) {
            this.connackByMoreThanOnce(clientConnectionContext, "receive maximum");
            return -1;
        }
        if (buf.readableBytes() < 2) {
            this.connackByRemainingLengthToShort(clientConnectionContext);
            return -1;
        }
        receiveMaximum = buf.readUnsignedShort();
        if (receiveMaximum == 0) {
            this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "A client (IP: {}) sent a CONNECT with receive maximum = '0'. This is not allowed.", "Sent a CONNECT with receive maximum = '0'", Mqtt5ConnAckReasonCode.PROTOCOL_ERROR, "Sent CONNECT with receive maximum set to '0'. This is a protocol violation.");
            return -1;
        }
        return receiveMaximum;
    }

    private long readMaximumPacketSize(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, long maximumPacketSize) {
        if (maximumPacketSize != Long.MAX_VALUE) {
            this.connackByMoreThanOnce(clientConnectionContext, "maximum packet size");
            return -1L;
        }
        if (buf.readableBytes() < 4) {
            this.connackByRemainingLengthToShort(clientConnectionContext);
            return -1L;
        }
        maximumPacketSize = buf.readUnsignedInt();
        if (maximumPacketSize == 0L) {
            this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "A client (IP: {}) sent a CONNECT with maximum packet size = '0'. This is not allowed.", "Sent a CONNECT with maximum packet size = '0'", Mqtt5ConnAckReasonCode.PROTOCOL_ERROR, "Sent CONNECT with packet size set to '0'. This is a protocol violation.");
            return -1L;
        }
        return maximumPacketSize;
    }

    private int readTopicAliasMaximum(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, int topicAliasMaximum) {
        if (topicAliasMaximum != Integer.MAX_VALUE) {
            this.connackByMoreThanOnce(clientConnectionContext, "topic alias maximum");
            return -1;
        }
        if (buf.readableBytes() < 2) {
            this.connackByRemainingLengthToShort(clientConnectionContext);
            return -1;
        }
        return buf.readUnsignedShort();
    }

    @Nullable
    private Boolean readBoolean(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, @Nullable Boolean current, @NotNull String key) {
        if (current != null) {
            this.connackByMoreThanOnce(clientConnectionContext, key);
            return null;
        }
        if (buf.readableBytes() < 1) {
            this.connackByRemainingLengthToShort(clientConnectionContext);
            return null;
        }
        byte read = buf.readByte();
        if (read == 0) {
            return false;
        }
        if (read == 1) {
            return true;
        }
        this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "A client (IP: {}) sent a CONNECT with a malformed boolean for " + key + ". This is not allowed.", "Sent a CONNECT with a malformed boolean for " + key, Mqtt5ConnAckReasonCode.MALFORMED_PACKET, "Sent CONNECT with a malformed boolean value.");
        return null;
    }

    @Nullable
    private String readAuthMethod(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, @Nullable String authMethod) {
        if (authMethod != null) {
            this.connackByMoreThanOnce(clientConnectionContext, "auth method");
            return null;
        }
        authMethod = MqttBinaryData.decodeString(buf, this.validateUTF8);
        if (authMethod == null) {
            this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "A client (IP: {}) sent a CONNECT with a malformed UTF-8 string for auth method. This is not allowed.", "Sent a CONNECT with a malformed UTF-8 string for auth method", Mqtt5ConnAckReasonCode.MALFORMED_PACKET, "Sent CONNECT with a malformed auth method.");
            return null;
        }
        return authMethod;
    }

    private byte @Nullable [] readAuthData(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, byte @Nullable [] authData) {
        if (authData != null) {
            this.connackByMoreThanOnce(clientConnectionContext, "auth data");
            return null;
        }
        authData = MqttBinaryData.decode(buf);
        if (authData == null) {
            this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "A client (IP: {}) sent a CONNECT with a malformed auth data. This is not allowed.", "Sent a CONNECT with a malformed auth data", Mqtt5ConnAckReasonCode.MALFORMED_PACKET, "Sent CONNECT with malformed auth data.");
            return null;
        }
        return authData;
    }

    @Nullable
    private MqttWillPublish decodeAndValidateWill(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, int willQos, boolean willRetain) {
        int willReadPropertyLength;
        MqttWillPublish.Mqtt5Builder mqtt5Builder = new MqttWillPublish.Mqtt5Builder();
        mqtt5Builder.withHivemqId(this.hiveMQId.get()).withQos(QoS.valueOf(willQos)).withRetain(willRetain);
        int willPropertiesLength = MqttVariableByteInteger.decode(buf);
        if (this.propertiesLengthInvalid(clientConnectionContext, buf, willPropertiesLength)) {
            return null;
        }
        long willDelayInterval = Long.MAX_VALUE;
        long messageExpiryInterval = Long.MAX_VALUE;
        Mqtt5PayloadFormatIndicator payloadFormatIndicator = null;
        String contentType = null;
        String responseTopic = null;
        byte[] correlationData = null;
        ImmutableList.Builder<MqttUserProperty> willUserPropertiesBuilder = null;
        int willPropertiesStartIndex = buf.readerIndex();
        block9: while ((willReadPropertyLength = buf.readerIndex() - willPropertiesStartIndex) < willPropertiesLength) {
            byte propertyIdentifier = buf.readByte();
            switch (propertyIdentifier) {
                case 24: {
                    if (this.willDelayIntervalInvalid(clientConnectionContext, buf, willDelayInterval)) {
                        return null;
                    }
                    willDelayInterval = buf.readUnsignedInt();
                    continue block9;
                }
                case 1: {
                    payloadFormatIndicator = this.readPayloadFormatIndicator(clientConnectionContext, buf, payloadFormatIndicator);
                    if (payloadFormatIndicator == null) {
                        return null;
                    }
                    mqtt5Builder.withPayloadFormatIndicator(payloadFormatIndicator);
                    continue block9;
                }
                case 2: {
                    if (this.messageExpiryIntervalInvalid(clientConnectionContext, buf, messageExpiryInterval)) {
                        return null;
                    }
                    messageExpiryInterval = buf.readUnsignedInt();
                    continue block9;
                }
                case 3: {
                    contentType = this.readContentType(clientConnectionContext, buf, contentType);
                    if (contentType == null) {
                        return null;
                    }
                    mqtt5Builder.withContentType(contentType);
                    continue block9;
                }
                case 8: {
                    responseTopic = this.readResponseTopic(clientConnectionContext, buf, responseTopic);
                    if (responseTopic == null) {
                        return null;
                    }
                    mqtt5Builder.withResponseTopic(responseTopic);
                    continue block9;
                }
                case 9: {
                    correlationData = this.readCorrelationData(clientConnectionContext, buf, correlationData);
                    if (correlationData == null) {
                        return null;
                    }
                    mqtt5Builder.withCorrelationData(correlationData);
                    continue block9;
                }
                case 38: {
                    if ((willUserPropertiesBuilder = this.readUserProperty(clientConnectionContext, buf, willUserPropertiesBuilder)) != null) continue block9;
                    return null;
                }
            }
            this.connackByInvalidPropertyIdentifier(clientConnectionContext, propertyIdentifier);
            return null;
        }
        if (willReadPropertyLength != willPropertiesLength) {
            this.connackByMalformedPropertyLength(clientConnectionContext);
            return null;
        }
        Mqtt5UserProperties userProperties = Mqtt5UserProperties.build(willUserPropertiesBuilder);
        if (this.invalidUserPropertiesLength(clientConnectionContext, userProperties)) {
            return null;
        }
        if (!this.readAndValidateTopic(clientConnectionContext, buf, mqtt5Builder)) {
            return null;
        }
        if (!this.readAndValidatePayload(clientConnectionContext, buf, mqtt5Builder)) {
            return null;
        }
        if (willDelayInterval == Long.MAX_VALUE) {
            willDelayInterval = 0L;
        }
        mqtt5Builder.withUserProperties(userProperties);
        mqtt5Builder.withDelayInterval(willDelayInterval);
        mqtt5Builder.withMessageExpiryInterval(messageExpiryInterval);
        return mqtt5Builder.build();
    }

    private boolean willDelayIntervalInvalid(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, long willDelayInterval) {
        if (willDelayInterval != Long.MAX_VALUE) {
            this.connackByMoreThanOnce(clientConnectionContext, "will delay interval");
            return true;
        }
        if (buf.readableBytes() < 4) {
            this.connackByRemainingLengthToShort(clientConnectionContext);
            return true;
        }
        return false;
    }

    private boolean readAndValidatePayload(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, @NotNull MqttWillPublish.Mqtt5Builder mqtt5Builder) {
        byte[] payload = MqttBinaryData.decode(buf);
        if (payload == null) {
            this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "A client (IP: {}) sent a CONNECT with malformed will payload. This is not allowed.", "Sent a CONNECT with malformed will payload", Mqtt5ConnAckReasonCode.MALFORMED_PACKET, "Sent CONNECT with a malformed Will payload.");
            return false;
        }
        mqtt5Builder.withPayload(payload);
        return true;
    }

    protected int decodeUTF8StringLength(@NotNull ClientConnectionContext clientConnectionContext, ByteBuf buf) {
        int utf8StringLength;
        block3: {
            block2: {
                if (buf.readableBytes() < 2) break block2;
                utf8StringLength = buf.readUnsignedShort();
                if (buf.readableBytes() >= utf8StringLength) break block3;
            }
            this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "A client (IP: {}) sent a CONNECT with an incorrect UTF-8 string length for 'will topic'.", "Incorrect CONNECT UTF-8 string length for 'will topic'", Mqtt5ConnAckReasonCode.MALFORMED_PACKET, "Sent CONNECT with incorrect will topic length.");
            return -1;
        }
        return utf8StringLength;
    }

    @Nullable
    protected String decodeUTF8Topic(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf) {
        int utf8StringLength = this.decodeUTF8StringLength(clientConnectionContext, buf);
        if (utf8StringLength == -1) {
            return null;
        }
        return this.decodeUTF8Topic(clientConnectionContext, buf, utf8StringLength);
    }

    @Nullable
    protected String decodeUTF8Topic(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, int utf8StringLength) {
        String utf8String = Strings.getValidatedPrefixedString(buf, utf8StringLength, this.validateUTF8);
        if (utf8String == null) {
            this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "A client (IP: {}) sent a CONNECT with a malformed 'will topic'. This is not allowed.", "Sent CONNECT with malformed UTF-8 String for 'will topic'", Mqtt5ConnAckReasonCode.MALFORMED_PACKET, "Sent CONNECT with malformed will topic.");
        }
        return utf8String;
    }

    private boolean readAndValidateTopic(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, @NotNull MqttWillPublish.Mqtt5Builder mqtt5Builder) {
        String willTopic = this.decodeUTF8Topic(clientConnectionContext, buf);
        if (willTopic == null) {
            return false;
        }
        if (willTopic.isEmpty()) {
            this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "A client (IP: {}) sent a CONNECT with empty will topic. This is not allowed.", "Sent a CONNECT with empty will topic", Mqtt5ConnAckReasonCode.TOPIC_NAME_INVALID, "Sent CONNECT with empty will topic.");
            return false;
        }
        if (this.topicInvalid(clientConnectionContext, willTopic, "will topic")) {
            return false;
        }
        mqtt5Builder.withTopic(willTopic);
        return true;
    }

    private boolean propertiesLengthInvalid(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, int propertyLength) {
        if (propertyLength < 0) {
            this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "A client (IP: {}) sent a CONNECT with malformed properties length.", "Sent CONNECT with malformed properties length", Mqtt5ConnAckReasonCode.PROTOCOL_ERROR, "Sent CONNECT with malformed properties length.");
            return true;
        }
        if (buf.readableBytes() < propertyLength) {
            this.connackByRemainingLengthToShort(clientConnectionContext);
            return true;
        }
        return false;
    }

    private boolean invalidUserPropertiesLength(@NotNull ClientConnectionContext clientConnectionContext, @NotNull Mqtt5UserProperties userProperties) {
        if ((long)userProperties.encodedLength() > this.maxUserPropertiesLength) {
            this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "A client (IP: {}) sent a CONNECT with user properties that are too large. Disconnecting client.", "Sent a CONNECT with too large user properties", Mqtt5ConnAckReasonCode.PACKET_TOO_LARGE, "Sent CONNECT with too large user properties.");
            return true;
        }
        return false;
    }

    @Nullable
    private String readResponseTopic(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, @Nullable String responseTopic) {
        if (responseTopic != null) {
            this.connackByMoreThanOnce(clientConnectionContext, "response topic");
            return null;
        }
        responseTopic = MqttBinaryData.decodeString(buf, this.validateUTF8);
        if (responseTopic == null) {
            this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "A client (IP: {}) sent a CONNECT with a malformed UTF-8 string for response topic. This is not allowed.", "Sent a CONNECT with a malformed UTF-8 string for response topic", Mqtt5ConnAckReasonCode.MALFORMED_PACKET, "Sent CONNECT with a malformed response topic.");
            return null;
        }
        if (this.topicInvalid(clientConnectionContext, responseTopic, "will response topic")) {
            return null;
        }
        return responseTopic;
    }

    private byte @Nullable [] readCorrelationData(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, byte @Nullable [] correlationData) {
        if (correlationData != null) {
            this.connackByMoreThanOnce(clientConnectionContext, "correlation data");
            return null;
        }
        correlationData = MqttBinaryData.decode(buf);
        if (correlationData == null) {
            this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "A client (IP: {}) sent a CONNECT with a malformed correlation data. This is not allowed.", "Sent a CONNECT with a malformed correlation data", Mqtt5ConnAckReasonCode.MALFORMED_PACKET, "Sent CONNECT with malformed correlation data.");
            return null;
        }
        return correlationData;
    }

    @Nullable
    private String readContentType(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, @Nullable String contentType) {
        if (contentType != null) {
            this.connackByMoreThanOnce(clientConnectionContext, "content type");
            return null;
        }
        contentType = MqttBinaryData.decodeString(buf, this.validateUTF8);
        if (contentType == null) {
            this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "A client (IP: {}) sent a CONNECT with a malformed UTF-8 string for content type. This is not allowed.", "Sent a CONNECT with a malformed UTF-8 string for content type", Mqtt5ConnAckReasonCode.MALFORMED_PACKET, "Sent CONNECT with malformed content type.");
            return null;
        }
        return contentType;
    }

    @Nullable
    private Mqtt5PayloadFormatIndicator readPayloadFormatIndicator(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, @Nullable Mqtt5PayloadFormatIndicator payloadFormatIndicator) {
        if (payloadFormatIndicator != null) {
            this.connackByMoreThanOnce(clientConnectionContext, "payload format indicator");
            return null;
        }
        if (buf.readableBytes() < 1) {
            this.connackByRemainingLengthToShort(clientConnectionContext);
            return null;
        }
        short payloadFormatIndicatorByte = buf.readUnsignedByte();
        payloadFormatIndicator = Mqtt5PayloadFormatIndicator.fromCode(payloadFormatIndicatorByte);
        if (payloadFormatIndicator == null) {
            this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "A client (IP: {}) sent a CONNECT with a wrong payload format indicator. This is not allowed.", "Sent a CONNECT with a wrong payload format indicator", Mqtt5ConnAckReasonCode.MALFORMED_PACKET, "Sent CONNECT with an invalid payload format indicator.");
            return null;
        }
        return payloadFormatIndicator;
    }

    private long decodeSessionExpiryInterval(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, long sessionExpiryInterval) {
        if (sessionExpiryInterval != Long.MAX_VALUE) {
            this.connackByMoreThanOnce(clientConnectionContext, "session expiry interval");
            return -1L;
        }
        if (buf.readableBytes() < 4) {
            this.connackByRemainingLengthToShort(clientConnectionContext);
            return -1L;
        }
        return buf.readUnsignedInt();
    }

    private boolean messageExpiryIntervalInvalid(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, long messageExpiryInterval) {
        if (messageExpiryInterval != Long.MAX_VALUE) {
            this.connackByMoreThanOnce(clientConnectionContext, "message expiry interval");
            return true;
        }
        if (buf.readableBytes() < 4) {
            this.connackByRemainingLengthToShort(clientConnectionContext);
            return true;
        }
        return false;
    }

    private boolean topicInvalid(@NotNull ClientConnectionContext clientConnectionContext, @NotNull String topicName, @NotNull String location) {
        if (topicName.isEmpty()) {
            this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "A client (ID: {}, IP: {}) sent a CONNECT with an empty " + location + ". This is not allowed.", "Sent a CONNECT with an empty " + location, Mqtt5ConnAckReasonCode.TOPIC_NAME_INVALID, String.format("CONNECT with empty %s.", location));
            return true;
        }
        if (Topics.containsWildcard(topicName)) {
            this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "A client (IP: {}) sent a CONNECT with a wildcard character (# or +) in the " + location + ". This is not allowed.", "Sent CONNECT with wildcard character (#/+) in the " + location, Mqtt5ConnAckReasonCode.TOPIC_NAME_INVALID, String.format("Not authorized to connect. Will topic contained wildcard characters (#/+) in the %s. The broker does not allow this.", location));
            return true;
        }
        return false;
    }

    private void connackByMoreThanOnce(@NotNull ClientConnectionContext clientConnectionContext, @NotNull String key) {
        this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "A client (IP: {}) sent a CONNECT with '" + key + "' included more than once. This is not allowed.", "Sent a CONNECT with '" + key + "' included more than once", Mqtt5ConnAckReasonCode.PROTOCOL_ERROR, String.format("Sent CONNECT with %s included more than once. This is a protocol violation.", key));
    }

    private void connackByRemainingLengthToShort(@NotNull ClientConnectionContext clientConnectionContext) {
        this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "A client (IP: {}) sent a CONNECT with remaining length too short. This is not allowed.", "Sent a CONNECT with remaining length too short", Mqtt5ConnAckReasonCode.MALFORMED_PACKET, "Sent CONNECT with not enough remaining read buffer length was sent. Property could not be read.");
    }

    private void connackByMalformedPropertyLength(@NotNull ClientConnectionContext clientConnectionContext) {
        this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "A client (IP: {}) sent a CONNECT with a malformed properties length. This is not allowed. Disconnecting client.", "Sent a CONNECT with a malformed properties length", Mqtt5ConnAckReasonCode.MALFORMED_PACKET, "Sent CONNECT with malformed properties length.");
    }

    private void connackByInvalidPropertyIdentifier(@NotNull ClientConnectionContext clientConnectionContext, int propertyIdentifier) {
        this.mqttConnacker.connackError(clientConnectionContext.getChannel(), "A client (IP: {}) sent a CONNECT with a invalid property identifier '" + propertyIdentifier + "'. This is not allowed. Disconnecting client.", "Sent CONNECT with invalid property identifier", Mqtt5ConnAckReasonCode.MALFORMED_PACKET, "Sent CONNECT with an invalid property identifier.");
    }
}

