/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.decoder.mqtt5;

import com.google.common.collect.ImmutableList;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.bootstrap.ioc.lazysingleton.LazySingleton;
import com.hivemq.codec.decoder.AbstractMqttDecoder;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.mqtt.handler.disconnect.MqttServerDisconnector;
import com.hivemq.mqtt.message.MessageType;
import com.hivemq.mqtt.message.disconnect.DISCONNECT;
import com.hivemq.mqtt.message.mqtt5.Mqtt5UserProperties;
import com.hivemq.mqtt.message.mqtt5.MqttUserProperty;
import com.hivemq.mqtt.message.reason.Mqtt5DisconnectReasonCode;
import io.netty.buffer.ByteBuf;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LazySingleton
public class Mqtt5DisconnectDecoder
extends AbstractMqttDecoder<DISCONNECT> {
    private static final Logger log = LoggerFactory.getLogger(Mqtt5DisconnectDecoder.class);
    private final long maxSessionExpiryInterval;

    @Inject
    public Mqtt5DisconnectDecoder(@NotNull MqttServerDisconnector disconnector, @NotNull FullConfigurationService configurationService) {
        super(disconnector, configurationService);
        this.maxSessionExpiryInterval = configurationService.mqttConfiguration().maxSessionExpiryInterval();
    }

    @Override
    @Nullable
    public DISCONNECT decode(@NotNull ClientConnectionContext clientConnectionContext, @NotNull ByteBuf buf, byte header) {
        if (!this.validateHeader(header)) {
            this.disconnectByInvalidFixedHeader(clientConnectionContext, MessageType.DISCONNECT);
            return null;
        }
        if (!buf.isReadable()) {
            return new DISCONNECT(Mqtt5DisconnectReasonCode.NORMAL_DISCONNECTION, null, Mqtt5UserProperties.NO_USER_PROPERTIES, null, Long.MAX_VALUE);
        }
        Mqtt5DisconnectReasonCode reasonCode = Mqtt5DisconnectReasonCode.fromCode(buf.readUnsignedByte());
        if (reasonCode == null) {
            this.disconnectByInvalidReasonCode(clientConnectionContext, MessageType.DISCONNECT);
            return null;
        }
        if (!buf.isReadable()) {
            return new DISCONNECT(reasonCode, null, Mqtt5UserProperties.NO_USER_PROPERTIES, null, Long.MAX_VALUE);
        }
        int propertiesLength = this.decodePropertiesLengthNoPayload(clientConnectionContext, buf, MessageType.DISCONNECT);
        if (propertiesLength == -1) {
            return null;
        }
        long sessionExpiryInterval = Long.MAX_VALUE;
        String serverReference = null;
        String reasonString = null;
        ImmutableList.Builder<MqttUserProperty> userPropertiesBuilder = null;
        block6: while (buf.isReadable()) {
            byte propertyIdentifier = buf.readByte();
            switch (propertyIdentifier) {
                case 17: {
                    sessionExpiryInterval = this.decodeSessionExpiryInterval(clientConnectionContext, buf, sessionExpiryInterval, Long.MAX_VALUE, MessageType.DISCONNECT);
                    if (sessionExpiryInterval == -1L) {
                        return null;
                    }
                    Long sessionExpiryIntervalFromChannel = clientConnectionContext.getClientSessionExpiryInterval();
                    if (sessionExpiryInterval != 0L && sessionExpiryIntervalFromChannel == 0L) {
                        this.disconnector.disconnect(clientConnectionContext.getChannel(), "A client (IP: {}) sent a DISCONNECT with session expiry interval, but session expiry interval was set to zero at CONNECT. This is not allowed. Disconnecting client.", "DISCONNECT with session expiry interval, but session expiry interval was set to zero at CONNECT.", Mqtt5DisconnectReasonCode.PROTOCOL_ERROR, "Sent DISCONNECT with invalid session expiry interval. Session expiry was set to zero on CONNECT and DISCONNECT contained a different value. This is a protocol violation.");
                        return null;
                    }
                    if (sessionExpiryInterval <= this.maxSessionExpiryInterval) continue block6;
                    if (log.isDebugEnabled()) {
                        log.debug("A client (IP: {}) sent a DISCONNECT with a session expiry interval of ('{}'), which is larger than configured maximum of '{}'", new Object[]{clientConnectionContext.getChannelIP().orElse("UNKNOWN"), sessionExpiryInterval, this.maxSessionExpiryInterval});
                    }
                    sessionExpiryInterval = this.maxSessionExpiryInterval;
                    continue block6;
                }
                case 28: {
                    if ((serverReference = this.decodeServerReference(clientConnectionContext, buf, serverReference, MessageType.DISCONNECT)) != null) continue block6;
                    return null;
                }
                case 31: {
                    if ((reasonString = this.decodeReasonString(clientConnectionContext, buf, reasonString, MessageType.DISCONNECT)) != null) continue block6;
                    return null;
                }
                case 38: {
                    if ((userPropertiesBuilder = this.readUserProperty(clientConnectionContext, buf, userPropertiesBuilder, MessageType.DISCONNECT)) != null) continue block6;
                    return null;
                }
            }
            this.disconnectByInvalidPropertyIdentifier(clientConnectionContext, propertyIdentifier, MessageType.DISCONNECT);
            return null;
        }
        Mqtt5UserProperties userProperties = Mqtt5UserProperties.build(userPropertiesBuilder);
        if (this.invalidUserPropertiesLength(clientConnectionContext, MessageType.DISCONNECT, userProperties)) {
            return null;
        }
        return new DISCONNECT(reasonCode, reasonString, userProperties, serverReference, sessionExpiryInterval);
    }
}

