/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.encoder.mqtt3;

import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.codec.encoder.mqtt3.AbstractVariableHeaderLengthEncoder;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.mqtt.message.publish.Mqtt3PUBLISH;
import com.hivemq.util.Strings;
import com.hivemq.util.Utf8Utils;
import io.netty.buffer.ByteBuf;

public class Mqtt3PublishEncoder
extends AbstractVariableHeaderLengthEncoder<Mqtt3PUBLISH> {
    private static final byte PUBLISH_FIXED_HEADER = 48;

    @Override
    public void encode(@NotNull ClientConnectionContext clientConnectionContext, @NotNull Mqtt3PUBLISH msg, @NotNull ByteBuf out) {
        int header = 48;
        int qos = msg.getQoS().getQosNumber();
        if (msg.isDuplicateDelivery()) {
            header = (byte)(header | 8);
        }
        if (msg.isRetain()) {
            header = (byte)(header | 1);
        }
        header = (byte)(header | qos << 1);
        out.writeByte(header);
        Mqtt3PublishEncoder.createRemainingLength(msg.getRemainingLength(), out);
        Strings.createPrefixedBytesFromString(msg.getTopic(), out);
        if (qos > 0) {
            out.writeShort(msg.getPacketIdentifier());
        }
        out.writeBytes(msg.getPayload());
    }

    @Override
    protected int remainingLength(@NotNull Mqtt3PUBLISH msg) {
        int length = 0;
        length += Utf8Utils.encodedLength(msg.getTopic());
        length += msg.getPayload().length;
        length += 2;
        if (msg.getQoS().getQosNumber() > 0) {
            length += 2;
        }
        return length;
    }
}

