/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.codec.encoder.mqtt5;

import com.hivemq.codec.encoder.mqtt5.Mqtt5MessageEncoderUtil;
import com.hivemq.codec.encoder.mqtt5.Mqtt5MessageWithUserPropertiesEncoder;
import com.hivemq.configuration.service.SecurityConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.mqtt.message.MessageType;
import com.hivemq.mqtt.message.disconnect.DISCONNECT;
import com.hivemq.mqtt.message.dropping.MessageDroppedService;
import com.hivemq.mqtt.message.reason.Mqtt5DisconnectReasonCode;
import io.netty.buffer.ByteBuf;
import javax.inject.Singleton;

@Singleton
public class Mqtt5DisconnectEncoder
extends Mqtt5MessageWithUserPropertiesEncoder.Mqtt5MessageWithOmissibleReasonCodeEncoder<DISCONNECT, Mqtt5DisconnectReasonCode> {
    private static final int FIXED_HEADER = MessageType.DISCONNECT.ordinal() << 4;

    public Mqtt5DisconnectEncoder(@NotNull MessageDroppedService messageDroppedService, @NotNull SecurityConfigurationService securityConfigurationService) {
        super(messageDroppedService, securityConfigurationService);
    }

    @Override
    int getFixedHeader() {
        return FIXED_HEADER;
    }

    @Override
    @NotNull
    Mqtt5DisconnectReasonCode getDefaultReasonCode() {
        return Mqtt5DisconnectReasonCode.NORMAL_DISCONNECTION;
    }

    @Override
    int additionalPropertyLength(@NotNull DISCONNECT message) {
        return Mqtt5MessageEncoderUtil.nullablePropertyEncodedLength(message.getServerReference());
    }

    @Override
    void encodeAdditionalProperties(@NotNull DISCONNECT message, @NotNull ByteBuf out) {
        Mqtt5MessageEncoderUtil.encodeNullableProperty(28, message.getServerReference(), out);
    }
}

