/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.configuration.reader;

import com.google.common.collect.ImmutableList;
import com.hivemq.configuration.entity.HiveMQConfigEntity;
import com.hivemq.configuration.entity.listener.TCPListenerEntity;
import com.hivemq.configuration.entity.listener.TlsTCPListenerEntity;
import com.hivemq.configuration.entity.listener.TlsWebsocketListenerEntity;
import com.hivemq.configuration.entity.listener.WebsocketListenerEntity;
import com.hivemq.configuration.reader.ConfigurationFile;
import com.hivemq.configuration.reader.ListenerConfigurator;
import com.hivemq.configuration.reader.MqttConfigurator;
import com.hivemq.configuration.reader.PersistenceConfigurator;
import com.hivemq.configuration.reader.RestrictionConfigurator;
import com.hivemq.configuration.reader.SecurityConfigurator;
import com.hivemq.configuration.reader.UsageStatisticsConfigurator;
import com.hivemq.exceptions.UnrecoverableException;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.util.EnvVarUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigFileReader {
    private static final Logger log = LoggerFactory.getLogger(ConfigFileReader.class);
    @NotNull
    private final ConfigurationFile configurationFile;
    @NotNull
    private final EnvVarUtil envVarUtil;
    @NotNull
    private final ListenerConfigurator listenerConfigurator;
    @NotNull
    private final MqttConfigurator mqttConfigurator;
    @NotNull
    private final RestrictionConfigurator restrictionConfigurator;
    @NotNull
    private final SecurityConfigurator securityConfigurator;
    @NotNull
    private final UsageStatisticsConfigurator usageStatisticsConfigurator;
    @NotNull
    private final PersistenceConfigurator persistenceConfigurator;

    public ConfigFileReader(@NotNull ConfigurationFile configurationFile, @NotNull RestrictionConfigurator restrictionConfigurator, @NotNull SecurityConfigurator securityConfigurator, @NotNull EnvVarUtil envVarUtil, @NotNull UsageStatisticsConfigurator usageStatisticsConfigurator, @NotNull MqttConfigurator mqttConfigurator, @NotNull ListenerConfigurator listenerConfigurator, @NotNull PersistenceConfigurator persistenceConfigurator) {
        this.configurationFile = configurationFile;
        this.envVarUtil = envVarUtil;
        this.listenerConfigurator = listenerConfigurator;
        this.mqttConfigurator = mqttConfigurator;
        this.restrictionConfigurator = restrictionConfigurator;
        this.securityConfigurator = securityConfigurator;
        this.usageStatisticsConfigurator = usageStatisticsConfigurator;
        this.persistenceConfigurator = persistenceConfigurator;
    }

    public void applyConfig() {
        this.setConfigFromXML();
    }

    @NotNull
    HiveMQConfigEntity getDefaultConfig() {
        return new HiveMQConfigEntity();
    }

    @NotNull
    Class<? extends HiveMQConfigEntity> getConfigEntityClass() {
        return HiveMQConfigEntity.class;
    }

    @NotNull
    List<Class<?>> getInheritedEntityClasses() {
        return ImmutableList.of(TCPListenerEntity.class, WebsocketListenerEntity.class, TlsTCPListenerEntity.class, TlsWebsocketListenerEntity.class);
    }

    private void setConfigFromXML() {
        if (this.configurationFile.file().isPresent()) {
            File configFile = this.configurationFile.file().get();
            log.debug("Reading configuration file {}", (Object)configFile);
            try {
                Class[] classes = (Class[])ImmutableList.builder().add(this.getConfigEntityClass()).addAll(this.getInheritedEntityClasses()).build().toArray((Object[])new Class[0]);
                JAXBContext context = JAXBContext.newInstance((Class[])classes);
                Unmarshaller unmarshaller = context.createUnmarshaller();
                String configFileContent = new String(Files.readAllBytes(configFile.toPath()), StandardCharsets.UTF_8);
                configFileContent = this.envVarUtil.replaceEnvironmentVariablePlaceholders(configFileContent);
                ByteArrayInputStream is = new ByteArrayInputStream(configFileContent.getBytes(StandardCharsets.UTF_8));
                StreamSource streamSource = new StreamSource(is);
                this.setConfiguration((HiveMQConfigEntity)unmarshaller.unmarshal((Source)streamSource, this.getConfigEntityClass()).getValue());
            }
            catch (Exception e) {
                if (e.getCause() instanceof UnrecoverableException) {
                    if (((UnrecoverableException)e.getCause()).isShowException()) {
                        log.error("An unrecoverable Exception occurred. Exiting HiveMQ", (Throwable)e);
                        log.debug("Original error message:", (Throwable)e);
                    }
                    System.exit(1);
                }
                log.error("Could not read the configuration file {}. Using default config", (Object)configFile.getAbsolutePath());
                log.debug("Original error message:", (Throwable)e);
                this.setConfiguration(this.getDefaultConfig());
            }
        } else {
            this.setConfiguration(this.getDefaultConfig());
        }
    }

    void setConfiguration(@NotNull HiveMQConfigEntity config) {
        this.listenerConfigurator.setListenerConfig(config.getListenerConfig());
        this.mqttConfigurator.setMqttConfig(config.getMqttConfig());
        this.restrictionConfigurator.setRestrictionsConfig(config.getRestrictionsConfig());
        this.securityConfigurator.setSecurityConfig(config.getSecurityConfig());
        this.usageStatisticsConfigurator.setUsageStatisticsConfig(config.getUsageStatisticsConfig());
        this.persistenceConfigurator.setPersistenceConfig(config.getPersistenceConfig());
    }
}

