/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.embedded.internal;

import com.codahale.metrics.MetricRegistry;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Injector;
import com.hivemq.HiveMQServer;
import com.hivemq.configuration.ConfigurationBootstrap;
import com.hivemq.configuration.info.SystemInformationImpl;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.configuration.service.InternalConfigurations;
import com.hivemq.embedded.EmbeddedExtension;
import com.hivemq.embedded.EmbeddedHiveMQ;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.util.ThreadFactoryUtil;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EmbeddedHiveMQImpl
implements EmbeddedHiveMQ {
    @NotNull
    private static final Logger log = LoggerFactory.getLogger(EmbeddedHiveMQImpl.class);
    @NotNull
    private final SystemInformationImpl systemInformation;
    @NotNull
    private final MetricRegistry metricRegistry;
    @VisibleForTesting
    @NotNull
    final ExecutorService stateChangeExecutor;
    @Nullable
    private final EmbeddedExtension embeddedExtension;
    @Nullable
    private FullConfigurationService configurationService;
    @Nullable
    private HiveMQServer hiveMQServer;
    @NotNull
    private State currentState = State.STOPPED;
    @NotNull
    private State desiredState = State.STOPPED;
    @Nullable
    private Exception failedException;
    @NotNull
    private LinkedList<CompletableFuture<Void>> startFutures = new LinkedList();
    @NotNull
    private LinkedList<CompletableFuture<Void>> stopFutures = new LinkedList();
    @Nullable
    private Future<?> shutDownFuture;

    EmbeddedHiveMQImpl(@Nullable File conf, @Nullable File data, @Nullable File extensions) {
        this(conf, data, extensions, null);
    }

    EmbeddedHiveMQImpl(@Nullable File conf, @Nullable File data, @Nullable File extensions, @Nullable EmbeddedExtension embeddedExtension) {
        this.embeddedExtension = embeddedExtension;
        log.info("Setting default authentication behavior to ALLOW ALL");
        InternalConfigurations.AUTH_DENY_UNAUTHENTICATED_CONNECTIONS.set(false);
        this.systemInformation = new SystemInformationImpl(true, true, conf, data, extensions);
        this.metricRegistry = new MetricRegistry();
        this.stateChangeExecutor = Executors.newSingleThreadExecutor(ThreadFactoryUtil.create("embedded-hivemq-state-change-executor"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws ExecutionException, InterruptedException {
        EmbeddedHiveMQImpl embeddedHiveMQImpl = this;
        synchronized (embeddedHiveMQImpl) {
            if (this.shutDownFuture == null) {
                log.info("Closing EmbeddedHiveMQ.");
                this.desiredState = State.CLOSED;
                this.stateChangeExecutor.submit(this::stateChange);
                this.shutDownFuture = this.stateChangeExecutor.submit(this.stateChangeExecutor::shutdown);
            }
        }
        this.shutDownFuture.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stateChange() {
        State localDesiredState;
        LinkedList<CompletableFuture<Void>> localStopFutures;
        LinkedList<CompletableFuture<Void>> localStartFutures;
        EmbeddedHiveMQImpl embeddedHiveMQImpl = this;
        synchronized (embeddedHiveMQImpl) {
            localStartFutures = this.startFutures;
            localStopFutures = this.stopFutures;
            localDesiredState = this.desiredState;
            this.startFutures = new LinkedList();
            this.stopFutures = new LinkedList();
        }
        if (localDesiredState == State.CLOSED) {
            if (this.currentState != State.STOPPED && this.currentState != State.CLOSED) {
                this.performStop(localDesiredState, localStartFutures, localStopFutures);
            }
        } else if (this.currentState == State.FAILED) {
            if (this.failedException != null) {
                this.failFutureLists(this.failedException, localStartFutures, localStopFutures);
            } else {
                log.error("Encountered a FAILED EmbeddedHiveMQ state without a reason present.");
                this.failFutureLists(new IllegalStateException("FAILED EmbeddedHiveMQ state without a reason present"), localStartFutures, localStopFutures);
            }
        } else if (this.currentState == State.STOPPED) {
            if (localDesiredState == State.STOPPED) {
                this.failFutureList(new AbortedStateChangeException("EmbeddedHiveMQ was stopped"), localStartFutures);
                this.succeedFutureList(localStopFutures);
            } else if (localDesiredState == State.RUNNING) {
                long startTime = System.currentTimeMillis();
                log.info("Starting EmbeddedHiveMQ.");
                try {
                    this.systemInformation.init();
                    this.configurationService = ConfigurationBootstrap.bootstrapConfig(this.systemInformation);
                    this.hiveMQServer = new HiveMQServer(this.systemInformation, this.metricRegistry, this.configurationService, false);
                    this.hiveMQServer.bootstrap();
                    this.hiveMQServer.startInstance(this.embeddedExtension);
                    this.failFutureList(new AbortedStateChangeException("EmbeddedHiveMQ was started"), localStopFutures);
                    this.succeedFutureList(localStartFutures);
                    this.currentState = State.RUNNING;
                    log.info("Started EmbeddedHiveMQ in {}ms", (Object)(System.currentTimeMillis() - startTime));
                }
                catch (Exception ex) {
                    this.currentState = State.FAILED;
                    this.failedException = ex;
                    this.failFutureLists(ex, localStartFutures, localStopFutures);
                }
            }
        } else if (this.currentState == State.RUNNING) {
            if (localDesiredState == State.RUNNING) {
                this.failFutureList(new AbortedStateChangeException("EmbeddedHiveMQ was started"), localStopFutures);
                this.succeedFutureList(localStartFutures);
            } else if (localDesiredState == State.STOPPED) {
                log.info("Stopping EmbeddedHiveMQ.");
                this.performStop(localDesiredState, localStartFutures, localStopFutures);
            }
        }
    }

    private void performStop(@NotNull State desiredState, @NotNull List<CompletableFuture<Void>> startFutures, @NotNull List<CompletableFuture<Void>> stopFutures) {
        try {
            long startTime = System.currentTimeMillis();
            try {
                this.hiveMQServer.stop();
            }
            catch (Exception ex) {
                if (desiredState == State.CLOSED) {
                    log.error("Exception during running shutdown hook.", (Throwable)ex);
                }
                throw ex;
            }
            this.hiveMQServer = null;
            this.failFutureList(new AbortedStateChangeException("EmbeddedHiveMQ was stopped"), startFutures);
            this.succeedFutureList(stopFutures);
            this.currentState = State.STOPPED;
            log.info("Stopped EmbeddedHiveMQ in {}ms", (Object)(System.currentTimeMillis() - startTime));
        }
        catch (Exception ex) {
            this.currentState = State.FAILED;
            this.failedException = ex;
            this.failFutureLists(ex, startFutures, stopFutures);
        }
    }

    private void failFutureLists(@NotNull Exception exception, @NotNull List<CompletableFuture<Void>> startFutures, @NotNull List<CompletableFuture<Void>> stopFutures) {
        this.failFutureList(exception, startFutures);
        this.failFutureList(exception, stopFutures);
    }

    private void failFutureList(@NotNull Exception exception, @NotNull List<CompletableFuture<Void>> futures) {
        for (CompletableFuture<Void> future : futures) {
            future.completeExceptionally(exception);
        }
    }

    private void succeedFutureList(@NotNull List<CompletableFuture<Void>> futures) {
        for (CompletableFuture<Void> future : futures) {
            future.complete(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompletableFuture<Void> start() {
        EmbeddedHiveMQImpl embeddedHiveMQImpl = this;
        synchronized (embeddedHiveMQImpl) {
            if (this.desiredState == State.CLOSED) {
                return CompletableFuture.failedFuture(new IllegalStateException("EmbeddedHiveMQ was already closed"));
            }
            this.desiredState = State.RUNNING;
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            this.startFutures.add(future);
            this.stateChangeExecutor.execute(this::stateChange);
            return future;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompletableFuture<Void> stop() {
        EmbeddedHiveMQImpl embeddedHiveMQImpl = this;
        synchronized (embeddedHiveMQImpl) {
            if (this.desiredState == State.CLOSED) {
                return CompletableFuture.failedFuture(new IllegalStateException("EmbeddedHiveMQ was already closed"));
            }
            this.desiredState = State.STOPPED;
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            this.stopFutures.add(future);
            this.stateChangeExecutor.execute(this::stateChange);
            return future;
        }
    }

    @Override
    @NotNull
    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    @VisibleForTesting
    @Nullable
    Injector getInjector() {
        return this.hiveMQServer.getInjector();
    }

    private static class AbortedStateChangeException
    extends Exception {
        public AbortedStateChangeException(@NotNull String message) {
            super(message);
        }
    }

    private static enum State {
        RUNNING,
        STOPPED,
        FAILED,
        CLOSED;

    }
}

