/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.hivemq.common.shutdown.HiveMQShutdownHook;
import com.hivemq.common.shutdown.ShutdownHooks;
import com.hivemq.configuration.info.SystemInformation;
import com.hivemq.embedded.EmbeddedExtension;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extensions.ExtensionBootstrap;
import com.hivemq.extensions.HiveMQExtensionEvent;
import com.hivemq.extensions.HiveMQExtensions;
import com.hivemq.extensions.loader.ExtensionLifecycleHandler;
import com.hivemq.extensions.loader.ExtensionLoader;
import com.hivemq.extensions.services.auth.Authenticators;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ExtensionBootstrapImpl
implements ExtensionBootstrap {
    private static final Logger log = LoggerFactory.getLogger(ExtensionBootstrapImpl.class);
    @NotNull
    private final ExtensionLoader extensionLoader;
    @NotNull
    private final SystemInformation systemInformation;
    @NotNull
    private final ExtensionLifecycleHandler lifecycleHandler;
    @NotNull
    private final HiveMQExtensions hiveMQExtensions;
    @NotNull
    private final ShutdownHooks shutdownHooks;
    @NotNull
    private final Authenticators authenticators;

    @Inject
    public ExtensionBootstrapImpl(@NotNull ExtensionLoader extensionLoader, @NotNull SystemInformation systemInformation, @NotNull ExtensionLifecycleHandler lifecycleHandler, @NotNull HiveMQExtensions hiveMQExtensions, @NotNull ShutdownHooks shutdownHooks, @NotNull Authenticators authenticators) {
        this.extensionLoader = extensionLoader;
        this.systemInformation = systemInformation;
        this.lifecycleHandler = lifecycleHandler;
        this.hiveMQExtensions = hiveMQExtensions;
        this.shutdownHooks = shutdownHooks;
        this.authenticators = authenticators;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> startExtensionSystem(@Nullable EmbeddedExtension embeddedExtension) {
        HiveMQExtensionEvent extensionEvent;
        log.info("Starting HiveMQ extension system.");
        this.shutdownHooks.add(new ExtensionSystemShutdownHook(this));
        Path extensionFolder = this.systemInformation.getExtensionsFolder().toPath();
        ImmutableCollection<HiveMQExtensionEvent> hiveMQExtensionEvents = this.extensionLoader.loadExtensions(extensionFolder, this.systemInformation.isEmbedded());
        ImmutableList.Builder extensionEventBuilder = ImmutableList.builder().addAll(hiveMQExtensionEvents);
        if (embeddedExtension != null && (extensionEvent = this.extensionLoader.loadEmbeddedExtension(embeddedExtension)) != null) {
            extensionEventBuilder.add((Object)extensionEvent);
        }
        ImmutableList allExtensions = extensionEventBuilder.build();
        return this.lifecycleHandler.handleExtensionEvents((ImmutableCollection<HiveMQExtensionEvent>)allExtensions).thenAccept(v -> this.authenticators.checkAuthenticationSafetyAndLifeness());
    }

    @Override
    public void stopExtensionSystem() {
        ImmutableList events = (ImmutableList)this.hiveMQExtensions.getEnabledHiveMQExtensions().values().stream().map(extension -> new HiveMQExtensionEvent(HiveMQExtensionEvent.Change.DISABLE, extension.getId(), extension.getStartPriority(), extension.getExtensionFolderPath(), extension.isEmbedded())).collect(ImmutableList.toImmutableList());
        this.lifecycleHandler.handleExtensionEvents((ImmutableCollection<HiveMQExtensionEvent>)events).join();
    }

    private static class ExtensionSystemShutdownHook
    implements HiveMQShutdownHook {
        private static final Logger log = LoggerFactory.getLogger(ExtensionSystemShutdownHook.class);
        @NotNull
        private final ExtensionBootstrap extensionBootstrap;

        private ExtensionSystemShutdownHook(@NotNull ExtensionBootstrap extensionBootstrap) {
            this.extensionBootstrap = extensionBootstrap;
        }

        @Override
        @NotNull
        public String name() {
            return "Extension System Shutdown Hook";
        }

        @Override
        @NotNull
        public HiveMQShutdownHook.Priority priority() {
            return HiveMQShutdownHook.Priority.VERY_LOW;
        }

        @Override
        public void run() {
            log.info("Shutting down extension system");
            try {
                this.extensionBootstrap.stopExtensionSystem();
            }
            catch (Exception e) {
                log.error("Exception at Extension system shutdown", (Throwable)e);
            }
        }
    }
}

