/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions;

import com.google.common.base.Preconditions;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.configuration.service.entity.TcpListener;
import com.hivemq.configuration.service.entity.TlsTcpListener;
import com.hivemq.configuration.service.entity.TlsWebsocketListener;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.client.parameter.ClientInformation;
import com.hivemq.extension.sdk.api.client.parameter.ClientTlsInformation;
import com.hivemq.extension.sdk.api.client.parameter.ConnectionInformation;
import com.hivemq.extension.sdk.api.client.parameter.Listener;
import com.hivemq.extension.sdk.api.client.parameter.ListenerType;
import com.hivemq.extension.sdk.api.packets.general.MqttVersion;
import com.hivemq.extensions.client.parameter.ClientInformationImpl;
import com.hivemq.extensions.client.parameter.ClientTlsInformationImpl;
import com.hivemq.extensions.client.parameter.ConnectionInformationImpl;
import com.hivemq.extensions.client.parameter.ListenerImpl;
import com.hivemq.mqtt.message.ProtocolVersion;
import com.hivemq.security.auth.SslClientCertificate;
import io.netty.channel.Channel;
import java.security.cert.X509Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionInformationUtil {
    private static final Logger log = LoggerFactory.getLogger(ExtensionInformationUtil.class);

    @NotNull
    public static ClientInformation getAndSetClientInformation(@NotNull Channel channel, @NotNull String clientId) {
        ClientConnectionContext clientConnectionContext = ClientConnectionContext.of(channel);
        if (clientConnectionContext.getExtensionClientInformation() == null) {
            clientConnectionContext.setExtensionClientInformation(new ClientInformationImpl(clientId));
        }
        return clientConnectionContext.getExtensionClientInformation();
    }

    @NotNull
    public static ConnectionInformation getAndSetConnectionInformation(@NotNull Channel channel) {
        ClientConnectionContext clientConnectionContext = ClientConnectionContext.of(channel);
        if (clientConnectionContext.getExtensionConnectionInformation() == null) {
            clientConnectionContext.setExtensionConnectionInformation(new ConnectionInformationImpl(clientConnectionContext));
        }
        return clientConnectionContext.getExtensionConnectionInformation();
    }

    @NotNull
    public static MqttVersion mqttVersionFromChannel(@NotNull Channel channel) {
        Preconditions.checkNotNull((Object)channel, (Object)"channel must never be null");
        ProtocolVersion protocolVersion = ClientConnectionContext.of(channel).getProtocolVersion();
        Preconditions.checkNotNull((Object)((Object)protocolVersion), (Object)"protocol version must never be null");
        return ExtensionInformationUtil.mqttVersionFromProtocolVersion(protocolVersion);
    }

    @NotNull
    public static MqttVersion mqttVersionFromProtocolVersion(@NotNull ProtocolVersion protocolVersion) {
        switch (protocolVersion) {
            case MQTTv3_1: {
                return MqttVersion.V_3_1;
            }
            case MQTTv3_1_1: {
                return MqttVersion.V_3_1_1;
            }
        }
        return MqttVersion.V_5;
    }

    @Nullable
    public static Listener getListenerFromChannel(@NotNull Channel channel) {
        Preconditions.checkNotNull((Object)channel, (Object)"channel must never be null");
        com.hivemq.configuration.service.entity.Listener hiveMQListener = ClientConnectionContext.of(channel).getConnectedListener();
        if (hiveMQListener == null) {
            return null;
        }
        return new ListenerImpl(hiveMQListener);
    }

    @NotNull
    public static ListenerType listenerTypeFromInstance(@NotNull com.hivemq.configuration.service.entity.Listener hiveMQListener) {
        if (hiveMQListener instanceof TlsTcpListener) {
            return ListenerType.TLS_TCP_LISTENER;
        }
        if (hiveMQListener instanceof TcpListener) {
            return ListenerType.TCP_LISTENER;
        }
        if (hiveMQListener instanceof TlsWebsocketListener) {
            return ListenerType.TLS_WEBSOCKET_LISTENER;
        }
        return ListenerType.WEBSOCKET_LISTENER;
    }

    @Nullable
    public static ClientTlsInformation getTlsInformationFromChannel(@NotNull Channel channel) {
        Preconditions.checkNotNull((Object)channel, (Object)"channel must never be null");
        ClientConnectionContext clientConnectionContext = ClientConnectionContext.of(channel);
        try {
            String cipher = clientConnectionContext.getAuthCipherSuite();
            String protocol = clientConnectionContext.getAuthProtocol();
            String sniHostname = clientConnectionContext.getAuthSniHostname();
            SslClientCertificate sslClientCertificate = clientConnectionContext.getAuthCertificate();
            if (cipher == null || protocol == null) {
                return null;
            }
            if (sslClientCertificate == null) {
                return new ClientTlsInformationImpl(null, null, cipher, protocol, sniHostname);
            }
            X509Certificate certificate = (X509Certificate)sslClientCertificate.certificate();
            X509Certificate[] certificateChain = (X509Certificate[])sslClientCertificate.certificateChain();
            return new ClientTlsInformationImpl(certificate, certificateChain, cipher, protocol, sniHostname);
        }
        catch (Exception e) {
            log.debug("Tls information creation failed: ", (Throwable)e);
            return null;
        }
    }
}

