/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;

public class ListenableFutureConverter {
    @NotNull
    public static <T, U> CompletableFuture<U> toCompletable(@NotNull ListenableFuture<T> listenableFuture, @NotNull Function<T, U> converter, boolean nullableResult, @NotNull Executor executor) {
        return ListenableFutureConverter.createCompletable(listenableFuture, converter, nullableResult, executor);
    }

    @NotNull
    public static <T, U> CompletableFuture<U> toCompletable(@NotNull ListenableFuture<T> listenableFuture, @NotNull Function<T, U> converter, @NotNull Executor executor) {
        return ListenableFutureConverter.createCompletable(listenableFuture, converter, true, executor);
    }

    @NotNull
    public static <T> CompletableFuture<T> toCompletable(@NotNull ListenableFuture<T> listenableFuture, @NotNull Executor executor) {
        return ListenableFutureConverter.createCompletable(listenableFuture, Function.identity(), true, executor);
    }

    @NotNull
    public static <T> CompletableFuture<Void> toVoidCompletable(@NotNull ListenableFuture<T> listenableFuture, @NotNull Executor executor) {
        return ListenableFutureConverter.createCompletable(listenableFuture, result -> null, true, executor);
    }

    @NotNull
    private static <T, U> CompletableFuture<U> createCompletable(final @NotNull ListenableFuture<T> listenableFuture, final @NotNull Function<T, U> converter, final boolean nullableResult, @NotNull Executor executor) {
        final ClassLoader callingThreadClassLoader = Thread.currentThread().getContextClassLoader();
        final CompletableFuture completableFuture = new CompletableFuture<U>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                boolean cancelled = listenableFuture.cancel(mayInterruptIfRunning);
                ClassLoader current = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(callingThreadClassLoader);
                    super.cancel(cancelled);
                    boolean bl = cancelled;
                    return bl;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(current);
                }
            }
        };
        Futures.addCallback(listenableFuture, (FutureCallback)new FutureCallback<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSuccess(T result) {
                ClassLoader current = Thread.currentThread().getContextClassLoader();
                try {
                    if (nullableResult && result == null) {
                        Thread.currentThread().setContextClassLoader(callingThreadClassLoader);
                        completableFuture.complete(null);
                    } else {
                        Object convertedResult = converter.apply(result);
                        Thread.currentThread().setContextClassLoader(callingThreadClassLoader);
                        completableFuture.complete(convertedResult);
                    }
                }
                catch (Throwable throwable) {
                    Thread.currentThread().setContextClassLoader(callingThreadClassLoader);
                    completableFuture.completeExceptionally(throwable);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(current);
                }
            }

            public void onFailure(@NotNull Throwable ex) {
                ClassLoader current = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(callingThreadClassLoader);
                    completableFuture.completeExceptionally(ex);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(current);
                }
            }
        }, (Executor)executor);
        return completableFuture;
    }
}

