/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.auth;

import com.google.common.base.Preconditions;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.async.Async;
import com.hivemq.extension.sdk.api.async.TimeoutFallback;
import com.hivemq.extension.sdk.api.auth.parameter.EnhancedAuthOutput;
import com.hivemq.extension.sdk.api.packets.auth.ModifiableDefaultPermissions;
import com.hivemq.extension.sdk.api.packets.general.DisconnectedReasonCode;
import com.hivemq.extensions.auth.AuthOutput;
import com.hivemq.extensions.auth.parameter.ModifiableClientSettingsImpl;
import com.hivemq.extensions.executor.PluginOutPutAsyncer;
import com.hivemq.mqtt.message.reason.Mqtt5DisconnectReasonCode;
import java.time.Duration;

public class ReAuthOutput
extends AuthOutput<EnhancedAuthOutput>
implements EnhancedAuthOutput {
    @NotNull
    private Mqtt5DisconnectReasonCode reasonCode = Mqtt5DisconnectReasonCode.NOT_AUTHORIZED;
    @NotNull
    private Mqtt5DisconnectReasonCode timeoutReasonCode = Mqtt5DisconnectReasonCode.NOT_AUTHORIZED;

    public ReAuthOutput(@NotNull PluginOutPutAsyncer asyncer, boolean validateUTF8, @NotNull ModifiableDefaultPermissions defaultPermissions, @NotNull ModifiableClientSettingsImpl clientSettings, int timeout) {
        super(asyncer, validateUTF8, defaultPermissions, clientSettings, timeout);
        this.setDefaultReasonStrings();
    }

    ReAuthOutput(@NotNull AuthOutput<EnhancedAuthOutput> prevOutput) {
        super(prevOutput);
        this.setDefaultReasonStrings();
    }

    private void setDefaultReasonStrings() {
        this.reasonString = "Re-authentication failed";
        this.timeoutReasonString = "Re-authentication failed, authenticator timed out";
    }

    public void failAuthentication(@NotNull DisconnectedReasonCode reasonCode) {
        Mqtt5DisconnectReasonCode disconnectReasonCode = ReAuthOutput.checkReasonCode(reasonCode);
        this.failAuthentication();
        this.reasonCode = disconnectReasonCode;
    }

    public void failAuthentication(@NotNull DisconnectedReasonCode reasonCode, @Nullable String reasonString) {
        Mqtt5DisconnectReasonCode disconnectReasonCode = ReAuthOutput.checkReasonCode(reasonCode);
        this.failAuthentication(reasonString);
        this.reasonCode = disconnectReasonCode;
    }

    @NotNull
    public Async<EnhancedAuthOutput> async(@NotNull Duration timeout, @NotNull TimeoutFallback fallback, @NotNull DisconnectedReasonCode reasonCode) {
        Mqtt5DisconnectReasonCode disconnectReasonCode = ReAuthOutput.checkReasonCode(reasonCode);
        Async async = this.async(timeout, fallback);
        this.timeoutReasonCode = disconnectReasonCode;
        return async;
    }

    @NotNull
    public Async<EnhancedAuthOutput> async(@NotNull Duration timeout, @NotNull TimeoutFallback fallback, @NotNull DisconnectedReasonCode reasonCode, @Nullable String reasonString) {
        Mqtt5DisconnectReasonCode disconnectReasonCode = ReAuthOutput.checkReasonCode(reasonCode);
        Async async = this.async(timeout, fallback, reasonString);
        this.timeoutReasonCode = disconnectReasonCode;
        return async;
    }

    @Override
    void failByTimeout() {
        super.failByTimeout();
        this.reasonCode = this.timeoutReasonCode;
    }

    @Override
    void failByUndecided() {
        super.failByUndecided();
        this.reasonCode = Mqtt5DisconnectReasonCode.NOT_AUTHORIZED;
        this.reasonString = "Re-authentication failed, authenticator did not decide authenticity";
    }

    @Override
    void failByThrowable(@NotNull Throwable throwable) {
        super.failByThrowable(throwable);
        this.reasonCode = Mqtt5DisconnectReasonCode.UNSPECIFIED_ERROR;
        this.reasonString = "Re-authentication failed, exception in authenticator";
    }

    @NotNull
    Mqtt5DisconnectReasonCode getReasonCode() {
        return this.reasonCode;
    }

    @NotNull
    private static Mqtt5DisconnectReasonCode checkReasonCode(@NotNull DisconnectedReasonCode disconnectedReasonCode) {
        Preconditions.checkNotNull((Object)disconnectedReasonCode, (Object)"Disconnected reason code must never be null");
        Mqtt5DisconnectReasonCode disconnectReasonCode = Mqtt5DisconnectReasonCode.from(disconnectedReasonCode);
        Preconditions.checkArgument((disconnectReasonCode != null ? 1 : 0) != 0, (Object)("The disconnected reason code " + disconnectedReasonCode.name() + " is not a DISCONNECT reason code and therefore must not be used during re-authentication."));
        Preconditions.checkArgument((disconnectReasonCode != Mqtt5DisconnectReasonCode.NORMAL_DISCONNECTION ? 1 : 0) != 0, (Object)"DISCONNECT reason code must not be NORMAL_DISCONNECTION for failed authentication");
        Preconditions.checkArgument((boolean)disconnectReasonCode.canBeSentByServer(), (Object)("The DISCONNECT reason code " + disconnectedReasonCode.name() + " cannot be sent by the server."));
        return disconnectReasonCode;
    }
}

