/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.auth.parameter;

import com.google.common.base.Preconditions;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.auth.parameter.ModifiableClientSettings;
import com.hivemq.extension.sdk.api.auth.parameter.OverloadProtectionThrottlingLevel;

public class ModifiableClientSettingsImpl
implements ModifiableClientSettings {
    private int receiveMaximum;
    @NotNull
    private OverloadProtectionThrottlingLevel overloadProtectionThrottlingLevel = OverloadProtectionThrottlingLevel.DEFAULT;
    private boolean modified = false;
    @Nullable
    private Long queueSizeMaximum;

    public ModifiableClientSettingsImpl(int receiveMaximum, @Nullable Long queueSizeMaximum) {
        this.receiveMaximum = receiveMaximum;
        this.queueSizeMaximum = queueSizeMaximum;
    }

    public void setClientReceiveMaximum(int receiveMaximum) {
        Preconditions.checkArgument((receiveMaximum >= 1 ? 1 : 0) != 0, (Object)("Receive maximum must NOT be less than 1 was " + receiveMaximum + "."));
        Preconditions.checkArgument((receiveMaximum <= 65535 ? 1 : 0) != 0, (Object)("Receive maximum must NOT be more than 65535 was " + receiveMaximum + "."));
        if (this.receiveMaximum == receiveMaximum) {
            return;
        }
        this.receiveMaximum = receiveMaximum;
        this.modified = true;
    }

    public void setOverloadProtectionThrottlingLevel(@NotNull OverloadProtectionThrottlingLevel level) {
        Preconditions.checkNotNull((Object)level, (Object)"Overload protection throttling level must not be null");
        if (this.overloadProtectionThrottlingLevel == level) {
            return;
        }
        this.overloadProtectionThrottlingLevel = level;
        this.modified = true;
    }

    public void setClientQueueSizeMaximum(long queueSizeMaximum) {
        Preconditions.checkArgument((queueSizeMaximum >= 1L ? 1 : 0) != 0, (Object)("Queue size maximum must NOT be less than 1, was " + queueSizeMaximum + "."));
        if (this.queueSizeMaximum != null && queueSizeMaximum == this.queueSizeMaximum) {
            return;
        }
        this.queueSizeMaximum = queueSizeMaximum;
        this.modified = true;
    }

    @NotNull
    public OverloadProtectionThrottlingLevel getOverloadProtectionThrottlingLevel() {
        return this.overloadProtectionThrottlingLevel;
    }

    public int getClientReceiveMaximum() {
        return this.receiveMaximum;
    }

    @Nullable
    public Long getQueueSizeMaximum() {
        return this.queueSizeMaximum;
    }

    public boolean isModified() {
        return this.modified;
    }
}

