/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.events.client.parameters;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extension.sdk.api.client.parameter.ClientInformation;
import com.hivemq.extension.sdk.api.client.parameter.ConnectionInformation;
import com.hivemq.extension.sdk.api.events.client.parameters.ConnectionStartInput;
import com.hivemq.extension.sdk.api.packets.connect.ConnectPacket;
import com.hivemq.extensions.ExtensionInformationUtil;
import com.hivemq.extensions.executor.task.PluginTaskInput;
import com.hivemq.extensions.packets.connect.ConnectPacketImpl;
import com.hivemq.mqtt.message.connect.CONNECT;
import io.netty.channel.Channel;
import java.util.Objects;

public class ConnectionStartInputImpl
implements ConnectionStartInput,
PluginTaskInput,
Supplier<ConnectionStartInputImpl> {
    @NotNull
    private final CONNECT connect;
    @NotNull
    private final ClientInformation clientInformation;
    @NotNull
    private final ConnectionInformation connectionInformation;
    @Nullable
    private ConnectPacket connectPacket;
    private final long connectTimestamp;

    public ConnectionStartInputImpl(@NotNull CONNECT connect, @NotNull Channel channel) {
        Preconditions.checkNotNull((Object)connect, (Object)"connect message must never be null");
        Preconditions.checkNotNull((Object)channel, (Object)"channel must never be null");
        this.connect = connect;
        this.connectionInformation = ExtensionInformationUtil.getAndSetConnectionInformation(channel);
        this.clientInformation = ExtensionInformationUtil.getAndSetClientInformation(channel, connect.getClientIdentifier());
        this.connectTimestamp = Objects.requireNonNullElse(ClientConnectionContext.of(channel).getConnectReceivedTimestamp(), System.currentTimeMillis());
    }

    @NotNull
    public ConnectionInformation getConnectionInformation() {
        return this.connectionInformation;
    }

    @NotNull
    public ClientInformation getClientInformation() {
        return this.clientInformation;
    }

    @NotNull
    public ConnectPacket getConnectPacket() {
        if (this.connectPacket == null) {
            this.connectPacket = new ConnectPacketImpl(this.connect, this.connectTimestamp);
        }
        return this.connectPacket;
    }

    @NotNull
    public ConnectionStartInputImpl get() {
        return this;
    }
}

