/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.executor;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.SettableFuture;
import com.hivemq.common.shutdown.HiveMQShutdownHook;
import com.hivemq.common.shutdown.ShutdownHooks;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.async.Async;
import com.hivemq.extensions.executor.PluginOutPutAsyncer;
import com.hivemq.extensions.executor.task.AsyncOutputImpl;
import com.hivemq.extensions.executor.task.PluginTaskOutput;
import com.hivemq.util.ThreadFactoryUtil;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class PluginOutputAsyncerImpl
implements PluginOutPutAsyncer {
    @NotNull
    private final ScheduledExecutorService scheduledExecutor;
    @NotNull
    private final ShutdownHooks shutdownHooks;

    @PostConstruct
    public void postConstruct() {
        this.shutdownHooks.add(new PluginOutputAsyncerShutdownHook(this.scheduledExecutor));
    }

    @Inject
    public PluginOutputAsyncerImpl(@NotNull ShutdownHooks shutdownHooks) {
        this.shutdownHooks = shutdownHooks;
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
        executor.setRemoveOnCancelPolicy(true);
        executor.setThreadFactory(ThreadFactoryUtil.create("extension-timeout-executor-%d"));
        this.scheduledExecutor = executor;
    }

    @Override
    @NotNull
    public <T extends PluginTaskOutput> Async<T> asyncify(@NotNull T output, @NotNull Duration timeout) {
        output.markAsAsync();
        SettableFuture<Boolean> asyncFuture = output.getAsyncFuture();
        Preconditions.checkNotNull(asyncFuture, (Object)"Async future cannot be null for async output");
        ScheduledFuture<?> scheduledFuture = this.scheduledExecutor.schedule(() -> {
            output.markAsTimedOut();
            asyncFuture.set((Object)false);
        }, timeout.toMillis(), TimeUnit.MILLISECONDS);
        return new AsyncOutputImpl<T>(output, asyncFuture, scheduledFuture);
    }

    static class PluginOutputAsyncerShutdownHook
    implements HiveMQShutdownHook {
        @NotNull
        private final ScheduledExecutorService scheduledExecutor;

        @VisibleForTesting
        PluginOutputAsyncerShutdownHook(@NotNull ScheduledExecutorService scheduledExecutor) {
            this.scheduledExecutor = scheduledExecutor;
        }

        @Override
        @NotNull
        public String name() {
            return "Extension Timeout Executor Shutdown Hook";
        }

        @Override
        public void run() {
            this.scheduledExecutor.shutdown();
        }
    }
}

