/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.handler;

import com.hivemq.bootstrap.ClientConnection;
import com.hivemq.configuration.service.FullConfigurationService;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.client.parameter.ClientInformation;
import com.hivemq.extension.sdk.api.client.parameter.ConnectionInformation;
import com.hivemq.extension.sdk.api.interceptor.suback.SubackOutboundInterceptor;
import com.hivemq.extension.sdk.api.interceptor.suback.parameter.SubackOutboundInput;
import com.hivemq.extension.sdk.api.interceptor.suback.parameter.SubackOutboundOutput;
import com.hivemq.extensions.ExtensionInformationUtil;
import com.hivemq.extensions.HiveMQExtension;
import com.hivemq.extensions.HiveMQExtensions;
import com.hivemq.extensions.client.ClientContextImpl;
import com.hivemq.extensions.executor.PluginOutPutAsyncer;
import com.hivemq.extensions.executor.PluginTaskExecutorService;
import com.hivemq.extensions.executor.task.PluginInOutTask;
import com.hivemq.extensions.executor.task.PluginInOutTaskContext;
import com.hivemq.extensions.handler.ExtensionParameterHolder;
import com.hivemq.extensions.interceptor.suback.parameter.SubackOutboundInputImpl;
import com.hivemq.extensions.interceptor.suback.parameter.SubackOutboundOutputImpl;
import com.hivemq.extensions.packets.suback.ModifiableSubackPacketImpl;
import com.hivemq.extensions.packets.suback.SubackPacketImpl;
import com.hivemq.mqtt.message.suback.SUBACK;
import com.hivemq.util.Exceptions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SubackOutboundInterceptorHandler {
    private static final Logger log = LoggerFactory.getLogger(SubackOutboundInterceptorHandler.class);
    @NotNull
    private final FullConfigurationService configurationService;
    @NotNull
    private final PluginOutPutAsyncer asyncer;
    @NotNull
    private final HiveMQExtensions hiveMQExtensions;
    @NotNull
    private final PluginTaskExecutorService executorService;

    @Inject
    public SubackOutboundInterceptorHandler(@NotNull FullConfigurationService configurationService, @NotNull PluginOutPutAsyncer asyncer, @NotNull HiveMQExtensions hiveMQExtensions, @NotNull PluginTaskExecutorService executorService) {
        this.configurationService = configurationService;
        this.asyncer = asyncer;
        this.hiveMQExtensions = hiveMQExtensions;
        this.executorService = executorService;
    }

    public void handleOutboundSuback(@NotNull ChannelHandlerContext ctx, @NotNull SUBACK suback, @NotNull ChannelPromise promise) {
        Channel channel = ctx.channel();
        ClientConnection clientConnection = ClientConnection.of(channel);
        String clientId = clientConnection.getClientId();
        if (clientId == null) {
            return;
        }
        ClientContextImpl clientContext = clientConnection.getExtensionClientContext();
        if (clientContext == null) {
            ctx.write((Object)suback, promise);
            return;
        }
        List<SubackOutboundInterceptor> interceptors = clientContext.getSubackOutboundInterceptors();
        if (interceptors.isEmpty()) {
            ctx.write((Object)suback, promise);
            return;
        }
        ClientInformation clientInfo = ExtensionInformationUtil.getAndSetClientInformation(channel, clientId);
        ConnectionInformation connectionInfo = ExtensionInformationUtil.getAndSetConnectionInformation(channel);
        SubackPacketImpl packet = new SubackPacketImpl(suback);
        SubackOutboundInputImpl input = new SubackOutboundInputImpl(clientInfo, connectionInfo, packet);
        ExtensionParameterHolder<SubackOutboundInputImpl> inputHolder = new ExtensionParameterHolder<SubackOutboundInputImpl>(input);
        ModifiableSubackPacketImpl modifiablePacket = new ModifiableSubackPacketImpl(packet, this.configurationService);
        SubackOutboundOutputImpl output = new SubackOutboundOutputImpl(this.asyncer, modifiablePacket);
        ExtensionParameterHolder<SubackOutboundOutputImpl> outputHolder = new ExtensionParameterHolder<SubackOutboundOutputImpl>(output);
        SubAckOutboundInterceptorContext context = new SubAckOutboundInterceptorContext(clientId, interceptors.size(), ctx, promise, inputHolder, outputHolder);
        for (SubackOutboundInterceptor interceptor : interceptors) {
            HiveMQExtension extension = this.hiveMQExtensions.getExtensionForClassloader(interceptor.getClass().getClassLoader());
            if (extension == null) {
                context.finishInterceptor();
                continue;
            }
            SubackOutboundInterceptorTask task = new SubackOutboundInterceptorTask(interceptor, extension.getId());
            this.executorService.handlePluginInOutTaskExecution(context, inputHolder, outputHolder, task);
        }
    }

    private static class SubackOutboundInterceptorTask
    implements PluginInOutTask<SubackOutboundInputImpl, SubackOutboundOutputImpl> {
        @NotNull
        private final SubackOutboundInterceptor interceptor;
        @NotNull
        private final String extensionId;

        SubackOutboundInterceptorTask(@NotNull SubackOutboundInterceptor interceptor, @NotNull String extensionId) {
            this.interceptor = interceptor;
            this.extensionId = extensionId;
        }

        @Override
        @NotNull
        public SubackOutboundOutputImpl apply(@NotNull SubackOutboundInputImpl input, @NotNull SubackOutboundOutputImpl output) {
            try {
                this.interceptor.onOutboundSuback((SubackOutboundInput)input, (SubackOutboundOutput)output);
            }
            catch (Throwable e) {
                log.warn("Uncaught exception was thrown from extension with id \"{}\" on outbound SUBACK interception. Extensions are responsible for their own exception handling.", (Object)this.extensionId, (Object)e);
                output.markAsFailed();
                Exceptions.rethrowError(e);
            }
            return output;
        }

        @Override
        @NotNull
        public ClassLoader getPluginClassLoader() {
            return this.interceptor.getClass().getClassLoader();
        }
    }

    private static class SubAckOutboundInterceptorContext
    extends PluginInOutTaskContext<SubackOutboundOutputImpl>
    implements Runnable {
        private final int interceptorCount;
        @NotNull
        private final AtomicInteger counter;
        @NotNull
        private final ChannelHandlerContext ctx;
        @NotNull
        private final ChannelPromise promise;
        @NotNull
        private final ExtensionParameterHolder<SubackOutboundInputImpl> inputHolder;
        @NotNull
        private final ExtensionParameterHolder<SubackOutboundOutputImpl> outputHolder;

        SubAckOutboundInterceptorContext(@NotNull String identifier, int interceptorCount, @NotNull ChannelHandlerContext ctx, @NotNull ChannelPromise promise, @NotNull ExtensionParameterHolder<SubackOutboundInputImpl> inputHolder, @NotNull ExtensionParameterHolder<SubackOutboundOutputImpl> outputHolder) {
            super(identifier);
            this.ctx = ctx;
            this.promise = promise;
            this.interceptorCount = interceptorCount;
            this.counter = new AtomicInteger(0);
            this.inputHolder = inputHolder;
            this.outputHolder = outputHolder;
        }

        @Override
        public void pluginPost(@NotNull SubackOutboundOutputImpl output) {
            if (output.isTimedOut()) {
                log.debug("Async timeout on outbound SUBACK interception. Discarding changes made by the interceptor.");
            } else if (output.isFailed()) {
                log.debug("Exception on outbound SUBACK interception. Discarding changes made by the interceptor.");
            } else if (output.getSubackPacket().isModified()) {
                this.inputHolder.set(this.inputHolder.get().update(output));
            }
            if (!this.finishInterceptor()) {
                this.outputHolder.set(output.update(this.inputHolder.get()));
            }
        }

        public boolean finishInterceptor() {
            if (this.counter.incrementAndGet() == this.interceptorCount) {
                this.ctx.executor().execute((Runnable)this);
                return true;
            }
            return false;
        }

        @Override
        public void run() {
            this.ctx.writeAndFlush((Object)SUBACK.from(this.inputHolder.get().getSubackPacket()), this.promise);
        }
    }
}

