/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.handler.tasks;

import com.google.common.util.concurrent.SettableFuture;
import com.hivemq.bootstrap.ClientConnectionContext;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.async.TimeoutFallback;
import com.hivemq.extensions.auth.parameter.PublishAuthorizerOutputImpl;
import com.hivemq.extensions.executor.task.PluginInOutTaskContext;
import io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.atomic.AtomicInteger;

public class PublishAuthorizerContext
extends PluginInOutTaskContext<PublishAuthorizerOutputImpl> {
    @NotNull
    private final PublishAuthorizerOutputImpl output;
    @NotNull
    private final SettableFuture<PublishAuthorizerOutputImpl> authorizeFuture;
    private final int authorizerCount;
    @NotNull
    private final ChannelHandlerContext ctx;
    @NotNull
    private final AtomicInteger counter;

    public PublishAuthorizerContext(@NotNull String identifier, @NotNull PublishAuthorizerOutputImpl output, @NotNull SettableFuture<PublishAuthorizerOutputImpl> authorizeFuture, int authorizerCount, @NotNull ChannelHandlerContext ctx) {
        super(identifier);
        this.output = output;
        this.authorizeFuture = authorizeFuture;
        this.authorizerCount = authorizerCount;
        this.ctx = ctx;
        this.counter = new AtomicInteger(0);
    }

    @Override
    public void pluginPost(@NotNull PublishAuthorizerOutputImpl pluginOutput) {
        if (pluginOutput.isAsync() && pluginOutput.isTimedOut() && pluginOutput.getTimeoutFallback() == TimeoutFallback.FAILURE) {
            pluginOutput.forceFailedAuthorization();
        }
        if (pluginOutput.getAuthorizationState() == PublishAuthorizerOutputImpl.AuthorizationState.FAIL || pluginOutput.getAuthorizationState() == PublishAuthorizerOutputImpl.AuthorizationState.DISCONNECT) {
            ClientConnectionContext.of(this.ctx.channel()).setIncomingPublishesSkipRest(true);
        }
        if (pluginOutput.isCompleted()) {
            this.authorizeFuture.set((Object)pluginOutput);
            return;
        }
        if (this.counter.incrementAndGet() == this.authorizerCount) {
            this.authorizeFuture.set((Object)pluginOutput);
        }
    }

    public void increment() {
        if (this.counter.incrementAndGet() == this.authorizerCount) {
            this.authorizeFuture.set((Object)this.output);
        }
    }
}

