/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.iteration;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extensions.iteration.BucketChunkResult;
import com.hivemq.extensions.iteration.ChunkCursor;
import com.hivemq.extensions.iteration.ChunkResult;
import com.hivemq.extensions.iteration.FetchCallback;
import com.hivemq.extensions.iteration.MultipleChunkResult;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;

public abstract class AllItemsFetchCallback<R, I>
implements FetchCallback<R> {
    @Override
    @NotNull
    public ListenableFuture<ChunkResult<R>> fetchNextResults(@Nullable ChunkCursor cursor) {
        ListenableFuture<MultipleChunkResult<I>> persistenceFuture = this.persistenceCall(cursor != null ? cursor : new ChunkCursor());
        return Futures.transform(persistenceFuture, input -> {
            Preconditions.checkNotNull((Object)input, (Object)"Chunk result cannot be null");
            return this.convertToChunkResult((MultipleChunkResult<I>)input);
        }, (Executor)MoreExecutors.directExecutor());
    }

    @NotNull
    public ChunkResult<R> convertToChunkResult(@NotNull MultipleChunkResult<I> input) {
        ImmutableList.Builder results = ImmutableList.builder();
        ImmutableMap.Builder lastKeys = ImmutableMap.builder();
        ImmutableSet.Builder finishedBuckets = ImmutableSet.builder();
        boolean finished = true;
        Map<Integer, BucketChunkResult<I>> values = input.getValues();
        for (Map.Entry<Integer, BucketChunkResult<I>> bucketResult : values.entrySet()) {
            BucketChunkResult<I> bucketChunkResult = bucketResult.getValue();
            if (bucketChunkResult.isFinished()) {
                finishedBuckets.add((Object)bucketChunkResult.getBucketIndex());
            } else {
                finished = false;
            }
            if (bucketChunkResult.getLastKey() != null) {
                lastKeys.put((Object)bucketChunkResult.getBucketIndex(), (Object)bucketChunkResult.getLastKey());
            }
            results.addAll(this.transform(bucketChunkResult.getValue()));
        }
        return new ChunkResult(results.build(), new ChunkCursor((Map<Integer, String>)lastKeys.build(), (Set<Integer>)finishedBuckets.build()), finished);
    }

    @NotNull
    protected abstract ListenableFuture<MultipleChunkResult<I>> persistenceCall(@NotNull ChunkCursor var1);

    @NotNull
    protected abstract Collection<R> transform(@NotNull I var1);
}

