/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.extensions.iteration;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.hivemq.extension.sdk.api.annotations.NotNull;
import com.hivemq.extension.sdk.api.annotations.Nullable;
import com.hivemq.extensions.iteration.AsyncIterator;
import com.hivemq.extensions.iteration.ChunkCursor;
import com.hivemq.extensions.iteration.ChunkResult;
import com.hivemq.extensions.iteration.FetchCallback;
import com.hivemq.extensions.iteration.ResultBuffer;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class AsyncLocalChunkIterator<V>
implements AsyncIterator<V> {
    @NotNull
    private final FetchCallback<V> fetchCallback;
    @NotNull
    private final ResultBuffer<V> resultBuffer;
    @NotNull
    private final AsyncIterator.ItemCallback<V> itemCallback;
    @NotNull
    private final ExecutorService executorService;
    private final CompletableFuture<Void> finishedFuture = new CompletableFuture();
    private final CompletableFuture<Void> fetchFuture = new CompletableFuture();
    private final AtomicBoolean iterating = new AtomicBoolean(false);
    private final AtomicBoolean aborted = new AtomicBoolean(false);
    private final Lock lock = new ReentrantLock();

    AsyncLocalChunkIterator(@NotNull FetchCallback<V> fetchCallback, @NotNull AsyncIterator.ItemCallback<V> itemCallback, @NotNull ExecutorService executorService) {
        this.fetchCallback = fetchCallback;
        this.resultBuffer = new ResultBuffer((cursor, resultBuffer) -> this.fetchNextChunk(cursor));
        this.itemCallback = itemCallback;
        this.executorService = executorService;
    }

    @Override
    public void fetchAndIterate() {
        this.fetchNextChunk(null);
    }

    private void fetchNextChunk(@Nullable ChunkCursor cursor) {
        ListenableFuture<ChunkResult<V>> singleFuture = this.fetchCallback.fetchNextResults(cursor);
        Futures.addCallback(singleFuture, new ChunkResultFutureCallback<V>(this.resultBuffer, this, this.lock), (Executor)this.executorService);
    }

    private synchronized void triggerIteration() {
        if (!this.iterating.compareAndSet(false, true)) {
            return;
        }
        if (this.aborted.get()) {
            return;
        }
        Collection<V> items = this.resultBuffer.getNextChunk();
        if (items == null) {
            if (this.fetchFuture.isDone()) {
                this.resultBuffer.clean();
                this.finishedFuture.complete(null);
            }
            this.iterating.set(false);
            return;
        }
        this.callCallback(items);
    }

    private synchronized void callCallback(@NotNull Collection<V> items) {
        if (this.aborted.get()) {
            return;
        }
        ListenableFuture<Boolean> itemFuture = this.itemCallback.onItems(items);
        Futures.addCallback(itemFuture, new ChunkCallback<V>(this, this.resultBuffer, this.lock), (Executor)this.executorService);
    }

    @Override
    @NotNull
    public CompletableFuture<Void> getFinishedFuture() {
        return this.finishedFuture;
    }

    @NotNull
    @VisibleForTesting
    CompletableFuture<Void> getFetchFuture() {
        return this.fetchFuture;
    }

    private void abortExceptionally(@NotNull Throwable t) {
        this.aborted.set(true);
        this.resultBuffer.clean();
        this.fetchFuture.completeExceptionally(t);
        this.finishedFuture.completeExceptionally(t);
    }

    private static class ChunkCallback<V>
    implements FutureCallback<Boolean> {
        @NotNull
        private final AsyncLocalChunkIterator<V> asyncLocalChunkIterator;
        @NotNull
        private final ResultBuffer<V> resultBuffer;
        @NotNull
        private final Lock lock;

        private ChunkCallback(@NotNull AsyncLocalChunkIterator<V> asyncLocalChunkIterator, @NotNull ResultBuffer<V> resultBuffer, @NotNull Lock lock) {
            this.asyncLocalChunkIterator = asyncLocalChunkIterator;
            this.resultBuffer = resultBuffer;
            this.lock = lock;
        }

        public void onSuccess(@Nullable Boolean result) {
            if (result == null) {
                this.asyncLocalChunkIterator.abortExceptionally(new NullPointerException("callback result cannot be null"));
                return;
            }
            if (!result.booleanValue()) {
                this.asyncLocalChunkIterator.aborted.set(true);
                this.resultBuffer.clean();
                this.asyncLocalChunkIterator.getFinishedFuture().complete(null);
                return;
            }
            this.lock.lock();
            try {
                Collection<V> items = this.resultBuffer.getNextChunk();
                if (items == null) {
                    this.asyncLocalChunkIterator.iterating.set(false);
                    if (this.asyncLocalChunkIterator.getFetchFuture().isDone()) {
                        this.resultBuffer.clean();
                        this.asyncLocalChunkIterator.getFinishedFuture().complete(null);
                    }
                    return;
                }
                this.asyncLocalChunkIterator.callCallback(items);
            }
            finally {
                this.lock.unlock();
            }
        }

        public void onFailure(@NotNull Throwable t) {
            this.asyncLocalChunkIterator.abortExceptionally(t);
        }
    }

    private static class ChunkResultFutureCallback<V>
    implements FutureCallback<ChunkResult<V>> {
        @NotNull
        private final ResultBuffer<V> resultBuffer;
        @NotNull
        private final AsyncLocalChunkIterator<V> asyncLocalChunkIterator;
        @NotNull
        private final Lock lock;

        ChunkResultFutureCallback(@NotNull ResultBuffer<V> resultBuffer, @NotNull AsyncLocalChunkIterator<V> asyncLocalChunkIterator, @NotNull Lock lock) {
            this.resultBuffer = resultBuffer;
            this.asyncLocalChunkIterator = asyncLocalChunkIterator;
            this.lock = lock;
        }

        public void onSuccess(ChunkResult<V> result) {
            if (this.asyncLocalChunkIterator.aborted.get()) {
                return;
            }
            if (result == null) {
                this.asyncLocalChunkIterator.abortExceptionally(new NullPointerException("chunk result cannot be null"));
                return;
            }
            this.lock.lock();
            try {
                if (!result.getResults().isEmpty()) {
                    this.resultBuffer.addChunk(result);
                }
                if (result.isFinished()) {
                    this.asyncLocalChunkIterator.getFetchFuture().complete(null);
                }
            }
            finally {
                this.lock.unlock();
            }
            this.asyncLocalChunkIterator.triggerIteration();
        }

        public void onFailure(@NotNull Throwable t) {
            this.asyncLocalChunkIterator.abortExceptionally(t);
        }
    }
}

